import { connect } from 'react-redux';
import { withRouter } from 'react-router';

import { IStore } from '../App/store';
import { Header } from './component';

export interface IHeaderMapStateToProps {
    userId: string | undefined;
    blockRules: any;
}

export const mapStateToProps = (store: IStore): IHeaderMapStateToProps => {
    return {
        userId: store.AdminUser?.userId,
        blockRules: store.AdminUser?.blockRules,
    };
};

export default withRouter<any, any>(connect<IHeaderMapStateToProps, {}, {}>(mapStateToProps)(Header));
