import { Dict } from '../../../types';
import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export const REQUESTS: Dict<any> = {
    GET_CAR_INFO: 'GET_CAR_INFO',
    GET_SCHEMA: 'GET_SCHEMA',
    SEND_FORM: 'SEND_FORM',
};

export const REQUEST: IComponentRequest = {
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_SCHEMA]: {
        api: 'incident/initiate/',
        cgiObj: {
            scheme: null,
        },
    },
    [REQUESTS.SEND_FORM]: {
        method: REQUEST_METHOD.POST,
        api: 'incident/initiate/',
    },
};
