import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { additionalWebphoneNumber } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { ArrayText } from '../renders';
import { schema } from './schema';

const keys = ['phone_number'];
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${additionalWebphoneNumber}`;

const AdditionalWebphoneNumber = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={keys}
                                  heads={keys}
                                  renders={
                                      { 'phone number': (props) => <ArrayText {...props}/> }
                                  }
                                  sortedBy={keys[0]}
                                  maxItemsInList={1}/>;
});

export default AdditionalWebphoneNumber;
