import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { aggregate_tags } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { ArrayText, Color } from '../renders';
import { schema } from './schema';

const keys = ['alias', 'color', 'tags'];

const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${aggregate_tags}`;
const AggregateTags = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={keys}
                                  heads={keys}
                                  renders={
                                      {
                                          'tags': (props) => <ArrayText {...props}/>,
                                          'color': (props) => <Color {...props}/>,
                                      }
                                  }
                                  sortedBy={keys[0]}/>;
});

export default AggregateTags;
