import { Dict } from '../../../../types';
import { controlType, ISchemaItem, SchemaItemVisual } from '../../FormConstructor/types';

export const schema: Dict<ISchemaItem> = {
    alias: {
        type: controlType.string,
        display_name: 'alias',
        required: true,
    },
    color: {
        type: controlType.string,
        visual: SchemaItemVisual.COLOR,
        display_name: 'color',
        default: '#bfbfbf',
    },
    tags: {
        type: controlType.array_types,
        display_name: 'tags',
        array_type: {
            type: controlType.string,
            display_name: 'tag',
        },
    },
};
