import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { billingCalculatorOfferNamesKey } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { ArrayText } from '../renders';
import { schema } from './schema';

const keys = ['offer_name'];
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${billingCalculatorOfferNamesKey}`;

const BillingCalculatorOfferNames = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={keys}
                                  heads={keys}
                                  renders={
                                      { 'tags': (props) => <ArrayText {...props}/> }
                                  }
                                  sortedBy={keys[0]}/>;
});

export default BillingCalculatorOfferNames;
