import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { block_rules_new } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { ArrayText, Label, Strong } from '../renders';
import { schema } from './schema';

const keys = ['active', 'name', 'description', 'roles'];
const body = [...keys];
const heads = ['active', 'Правило', 'Описание', 'Роли'];

const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${block_rules_new}`;
const BlockRules = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  renders={
                                      {
                                          'active': (props) => <Label {...props}/>,
                                          'roles': (props) => <ArrayText {...props}/>,
                                          'name': (props) => <Strong {...props}/>,
                                      }
                                  }
                                  body={body}
                                  heads={heads}
                                  sortedBy={keys[1]}/>;
});

export default BlockRules;
