import { Dict } from '../../../../types';
import { controlType, ISchemaItem } from '../../FormConstructor/types';

export const schema: Dict<ISchemaItem> = {
    name: {
        type: controlType.string,
        display_name: 'Правило', order: 1,
        required: true,
    },
    description: { type: controlType.text, display_name: 'Описание', order: 2 },
    type: {
        type: controlType.variants,
        multi_select: false,
        display_name: 'Тип',
        variants: ['show'],
        order: 3,
    },
    roles: {
        type: controlType.variants,
        multi_select: true,
        display_name: 'Роли',
        variants: [],
        order: 4,
        editable: true,
    },
    active: {
        type: controlType.bool,
        display_name: 'Активно',
        order: 6,
    },
};
