import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { chat_apologizes_list } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { schema } from './schema';

const body = [schema.apologize.display_name || ''];

const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${chat_apologizes_list}`;
const ChatApologizesList = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={body}
                                  sortedBy={body[0]}/>;
});

export default ChatApologizesList;
