import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { chat_defer_until } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { Label } from '../renders';
import { schema } from './schema';

const keys = ['enabled', 'queue', 'need_comment', 'max_day_period'];
const body = [...keys];
const heads = [...keys];

const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${chat_defer_until}`;
const ChatDeferUntil = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  renders={
                                      {
                                          'enabled': (props) => <Label {...props}/>,
                                          'need_comment': (props) => <Label {...props}/>,
                                      }
                                  }
                                  body={body}
                                  heads={heads}
                                  sortedBy={keys[1]}/>;
});

export default ChatDeferUntil;
