import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { chat_welcomes_list } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { Label, TimeText } from '../renders';
import { schema } from './schema';

const body = Object.keys(schema);
const heads = Object.entries(schema)?.map(el => el[1].display_name || el[0]);
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${chat_welcomes_list}`;

const ChatWelcomesList = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  sortedBy={body[0]}
                                  renders={
                                      {
                                          'since': (props) => <TimeText {...props}/>,
                                          'until': (props) => <TimeText {...props}/>,
                                          'ignore_time': (props) => <Label {...props}/>,
                                      }
                                  }/>;
});

export default ChatWelcomesList;
