import { Dict } from '../../../../types';
import { controlType, ISchemaItem } from '../../FormConstructor/types';

export const schema: Dict<ISchemaItem> = {
    welcome: {
        type: controlType.text,
        display_name: 'Приветствие',
    },
    since: {
        type: controlType.numeric,
        min: 0,
        max: 23,
        display_name: 'Начало интервала [0-23]',
    },
    until: {
        type: controlType.numeric,
        min: 0,
        max: 23,
        display_name: 'Окончание интервала [0-23]',
    },
    ignore_time: {
        type: controlType.bool,
        display_name: 'Игнорировать привязку',
    },
};
