import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { outgoing_chat2 } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { ChatType, Label, ShortText, TBodyItemProps } from '../renders';
import { schema } from './schema';

const keys = ['type', 'tag', 'initial_node', 'name', 'title', '_text', 'additional_comment', 'to_morning'];
const body = ['enabled', ...keys];
const heads = ['', ...keys];
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${outgoing_chat2}`;

const CreateOutgoingChat = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  renders={
                                      {
                                          'type': (props) => <ChatType {...props}/>,
                                          '_text': (props) => <TwoLineText {...props}/>,
                                          'additional_comment': (props) => <ShortText {...props}/>,
                                          'to_morning': (props) => <Label {...props}/>,
                                      }
                                  }
                                  sortedBy={keys[0]}/>;
});
export default CreateOutgoingChat;

const TwoLineText = (props) => {
    const _props1 = { item: props.raw.text1 } as TBodyItemProps;
    const _props2 = { item: props.raw.text2 } as TBodyItemProps;

    return <div>
        <div><ShortText {..._props1}/></div>
        <div><ShortText {..._props2}/></div>
    </div>;
};
