import { Dict } from '../../../../types';
import { CHAT_TYPE } from '../../CreateChatWindow/types';
import { controlType, ISchemaItem } from '../../FormConstructor/types';

export const schema: Dict<ISchemaItem> = {
    tag: {
        type: controlType.string,
        display_name: 'tag',
        required: true,
    },
    initial_node: {
        type: controlType.string,
        display_name: 'initial_node',
    },
    name: {
        type: controlType.string,
        display_name: 'name',
    },
    title: {
        type: controlType.string,
        display_name: 'title',
    },
    enabled: {
        type: controlType.bool,
        display_name: 'Enabled',
    },
    type: {
        type: controlType.variants,
        display_name: 'type',
        default: 'chat',
        variants: [CHAT_TYPE.chats, CHAT_TYPE.outgoing],
    },
    text1: {
        type: controlType.text,
        display_name: 'Первый текст',
    },
    text2: {
        type: controlType.text,
        display_name: 'Второй текст',
    },
    additional_comment: {
        type: controlType.text,
        display_name: 'additional_comment',
    },
    to_morning: {
        type: controlType.bool,
        display_name: 'defer to morning',
    },
};
