import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { dedicated_fleet_links } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { schema } from './schema';

const body = Object.keys(schema);
const heads = Object.entries(schema)?.map((el: any[]) => el[1].display_name || el[0]);
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${dedicated_fleet_links}`;

const DedicatedFleetLinks = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  sortedBy={body[0]}/>;
});

export default DedicatedFleetLinks;
