import React from 'react';

import { DISPATCHER_SETTINGS } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { Label } from '../renders';
import { schema } from './schema';

const body = Object.keys(schema);
const heads = Object.entries(schema)?.map(el => el[1].display_name || el[0]);

const DispatcherSettings = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={DISPATCHER_SETTINGS}
                                  body={body}
                                  heads={heads}
                                  sortedBy={body[0]}
                                  renders={
                                      {
                                          'skip_classification_check': (props) => <Label {...props}/>,
                                          'close_text_editor': (props) => <Label {...props}/>,
                                          'hide_last_session': (props) => <Label {...props} />,
                                      }
                                  }/>;
});

export default DispatcherSettings;
