import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { export_polygons_query } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { schema } from './schema';

const keys = ['name', 'title', 'query'];
const body = ['enabled', ...keys];
const heads = ['', ...keys];
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${export_polygons_query}`;

const ExportPolygonQuery = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  sortedBy={keys[0]}/>;
});
export default ExportPolygonQuery;
