import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { fast_answers } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { ArrayText } from '../renders';
import { schema } from './schema';

const keys = ['name', 'tags', 'text'];
const body = [...keys];
const heads = [...keys];
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${fast_answers}`;

const FastAnswers = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  renders={
                                      { 'tags': (props)=> <ArrayText {...props}/> }
                                  }
                                  sortedBy={keys[0]}/>;
});

export default FastAnswers;
