import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { fast_tags2 } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { ArrayText, Label } from '../renders';
import { schema } from './schema';

const keys = ['enabled', 'alias', 'tag', 'place', 'for_rules', 'tagType'];
const body = [...keys];
const heads = [...keys];
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${fast_tags2}`;

const FastTags = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  renders={
                                      {
                                          'enabled': (props) => <Label {...props}/>,
                                          'place': (props) => <ArrayText {...props}/>,
                                          'for_rules': (props) => <ForRules {...props}/>,
                                      }
                                  }
                                  sortedBy={keys[1]}/>;
});

export default FastTags;

const ForRules = (props) => {
    return <div>{props?.item?.only_for_rules && props?.item?.array_rules?.join(', ')}</div>;
};
