import { Dict } from '../../../../types';
import { buttonLocationDetails } from '../../../utils/sendLogs/eventTypes/buttonDetails';
import { controlType, ISchemaItem } from '../../FormConstructor/types';

export enum tagTypes {
    CLIENT = 'client',
    CAR = 'car'
}

export const schema: Dict<ISchemaItem> = {
    tag: {
        type: controlType.string,
        display_name: 'tag',
        required: true,
    },
    alias: {
        type: controlType.string,
        display_name: 'alias',
    },
    enabled: {
        type: controlType.bool,
        display_name: 'Enabled',
    },
    variable_field: {
        type: controlType.variable,
        control_field: {
            tagType: {
                type: controlType.variants,
                multi_select: false,
                variants: [tagTypes.CAR, tagTypes.CLIENT],
                display_name: 'Использовать тег для',
                default: tagTypes.CAR,
            },
        },
        variants_fields: {
            [tagTypes.CAR]: {
                place: {
                    type: controlType.variants,
                    multi_select: true,
                    display_name: 'Где показывать',
                    variants: [buttonLocationDetails.CAR_CARD, buttonLocationDetails.CLIENT_CARD],
                },
            },
            [tagTypes.CLIENT]: {},
        },
    },
    for_rules: {
        type: controlType.structure,
        display_name: 'Правила',
        structure: {
            only_for_rules: {
                type: controlType.bool,
                display_name: 'Показывать только для правил ниже',
            },
            'array_rules': {
                'type': controlType.array_types,
                'display_name': 'Массив правил для показа быстрого тега',
                'array_type': {
                    'type': controlType.string,
                    'display_name': 'Правило',
                    'order': 1,
                },
            },
        },
    },
};

export interface IFastTagItem {
    tag: string;
    tagType: tagTypes;
    alias: string;
    enabled: boolean;
    place: string[];
    for_rules?:{
        only_for_rules: boolean;
        array_rules: string[];
    };
}
