import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { important_car_tags } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { Label } from '../renders';
import { schema } from './schema';

const keys = ['tag', 'rise_up', 'check_to'];
const body = [...keys];
const heads = ['tag', 'показывать сверху', 'отметить ТО'];
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${important_car_tags}`;

const ImportantCarTags = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  renders={
                                      {
                                          'rise_up': (props) => <Label {...props}/>,
                                          'check_to': (props) => <Label {...props}/>,
                                      }
                                  }
                                  sortedBy={keys[0]}/>;
});

export default ImportantCarTags;
