import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { named_filters } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import * as style from './index.css';
import { schema } from './schema';

const body = Object.keys(schema);
const heads = Object.entries(schema)?.map(el => el[1].display_name || el[0]);
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${named_filters}`;

const NamedFilters = React.memo(() => {
    const validator = (data, changedData) => {
        const filtered = data.filter((item) => item.id === changedData?.id);

        return filtered.length > 1 ? new Error('Элемент с таким id уже существует') : null;
    };

    return <CommonInterfaceConfig className={style.namedFilters}
                                  schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  sortedBy={body[0]}
                                  validator={validator}/>;
});

export default NamedFilters;
