import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { polyFiltersKey } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { ArrayText } from '../renders';
import { schema } from './schema';

const keys = ['key', 'name', 'filter', 'tags', 'blockrules', 'roles'];
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${polyFiltersKey}`;

const PolyFilters = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={keys}
                                  heads={keys}
                                  renders={
                                      { 'tags': (props) => <ArrayText {...props}/> }
                                  }
                                  sortedBy={keys[0]}/>;
});

export default PolyFilters;
