import { Dict } from '../../../../types';
import { controlType, ISchemaItem } from '../../FormConstructor/types';

export const schema: Dict<ISchemaItem> = {
    key: {
        type: controlType.string,
        display_name: 'Ключ полигона (key)',
        required: true,
    },
    name: {
        type: controlType.string,
        display_name: 'Название полигона (name)',
        required: true,
    },
    filter: {
        type: controlType.array_types,
        display_name: 'Filters',
        array_type: {
            type: controlType.string,
            display_name: 'filter',
        },
    },
    tags: {
        type: controlType.array_types,
        display_name: 'Tags',
        array_type: {
            type: controlType.string,
            display_name: 'tag',
        },
    },
    blockrules: {
        display_name: 'Правила, по которым доступен полигон для просмотра на карте (по умолчанию - для всех) (blockrules)',
        type: controlType.array_types,
        array_type: {
            type: controlType.string,
            display_name: 'blockRule',
        },
    },
    roles: {
        display_name: 'Роли, которым всегда подсвечивать полигоны на карте (roles)',
        type: controlType.array_types,
        array_type: {
            type: controlType.string,
            display_name: 'role',
        },
    },
};
