import React from 'react';

import { REGISTRATION_FLOW } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { Label } from '../renders';
import { schema } from './schema';

const keys = ['enabled', 'order', 'type', 'id', 'title', 'init_tag'];
const body = [...keys, 'actions'];
const heads = [...keys, 'тег bulk-перезапроса'];

const RegistrationFlow = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={REGISTRATION_FLOW}
                                  body={body}
                                  heads={heads}
                                  renders={
                                      {
                                          'enabled': (props) => <Label {...props}/>,
                                          'actions': (props) => <Tag {...props}/>,
                                      }
                                  }
                                  sortedBy={keys[1]}/>;
});

const Tag = (props) => {
    const tags = props?.item?.filter(el => el.mainButton).map(el => el.tagName).join(', ');

    return <div>{tags}</div>;
};

export default RegistrationFlow;
