import { Dict } from '../../../../types';
import { controlType, ISchemaItem } from '../../FormConstructor/types';

export enum RegistrationFlowType {
    COMMON = 'common',
    BOT = 'bot',
}

export const RegistrationFlowTypeDescription = {
    [RegistrationFlowType.COMMON]: 'Задание',
    [RegistrationFlowType.BOT]: 'Проверка роботом',
};

export const schema: Dict<ISchemaItem> = {
    enabled: {
        type: controlType.bool,
        default: true,
        display_name: 'enabled',
    },
    type: {
        type: controlType.variants,
        variants: [
            {
                value: RegistrationFlowType.COMMON,
                description: RegistrationFlowTypeDescription[RegistrationFlowType.COMMON],
            },
            { value: RegistrationFlowType.BOT, description: RegistrationFlowTypeDescription[RegistrationFlowType.BOT] },
        ],
        display_name: 'type',
        default: RegistrationFlowType.COMMON,
        required: true,
    },
    id: {
        type: controlType.string,
        display_name: 'id (key)',
        required: true,
    },
    order: {
        type: controlType.numeric,
        display_name: 'order',
        default: 0,
        required: true,
    },
    title: {
        type: controlType.string,
        display_name: 'title',
    },
    description: {
        type: controlType.text,
        display_name: 'description',
    },
    actions: {
        type: controlType.array_types,
        array_type: {
            type: controlType.structure,
            structure: {
                buttonName: {
                    type: controlType.string,
                    display_name: 'Название кнопки',
                },
                tagName: {
                    type: controlType.string,
                    display_name: 'Навешиваемый тег',
                },
                initialData: {
                    type: controlType.json,
                    display_name: 'Начальные данные',
                },
                mainButton: {
                    type: controlType.bool,
                    display_name: 'Использовать для группового перезапроса',
                },
            },
            display_name: 'action',
        },
        display_name: 'Действия с заданием',
    },
    init_tag: {
        type: controlType.string,
        display_name: '',
    },
};

export interface RegistrationFlowItemAction {
    buttonName?: string;
    tagName?: string;
    initialData?: Dict<any>;
}

export interface RegistrationFlowItem {
    enabled: boolean;
    type: RegistrationFlowType;
    id: string;
    order: number;
    title?: string;
    description?: string;
    actions?: RegistrationFlowItemAction[];
    init_tag?:string;
}
