import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { system_alerts } from '../adminConfigKeys';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { Label } from '../renders';
import { schema } from './schema';

const keys = ['enabled', 'type', 'title', 'text'];
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${system_alerts}`;

const SystemAlerts = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={keys}
                                  heads={keys}
                                  renders={
                                      {
                                          'enabled': (props) => <Label {...props}/>,
                                      }
                                  }
                                  sortedBy={keys[1]}/>;
});

export default SystemAlerts;
