import { Dict } from '../../../../types';
import { controlType, ISchemaItem } from '../../FormConstructor/types';

export enum SystemAlertItemType {
    warning = 'warning',
    info = 'info'
}

export const schema: Dict<ISchemaItem> = {
    title: {
        type: controlType.string,
        display_name: 'title',
        required: true,
    },
    text: {
        type: controlType.text,
        display_name: 'text',
        required: true,
    },
    enabled: {
        type: controlType.bool,
        display_name: 'enabled',
    },
    type: {
        type: controlType.variants,
        variants: [
            { value: SystemAlertItemType.warning, description: '🟧️ факапное предупреждение' },
            { value: SystemAlertItemType.info, description: '🟦️ просто текст для информирования' },
        ],
        default: SystemAlertItemType.warning,
        required: true,
    },
};

export interface ISystemAlertItem {
    title: string;
    text: string;
    enabled: boolean;
    type: SystemAlertItemType;
}
