import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX, GVARS_SCOOTER_PREFIX } from '../../../constants';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { schema } from './schema';

const body = Object.keys(schema);
const heads = Object.entries(schema)?.map(el => el[1].display_name || el[0]);
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${GVARS_SCOOTER_PREFIX}`;

const TransformToScooter = React.memo(() => {
    return <CommonInterfaceConfig schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  sortedBy={body[0]}/>;
});

export default TransformToScooter;
