import React from 'react';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { CommonInterfaceConfig } from '../CommonIntefaceConfig';
import { Label, Strong } from '../renders';
import * as style from './index.css';
import { schema } from './schema';

const key = 'ui_settings';
const keys = ['active', 'ui', 'ruleName', 'roles'];
const body = [...keys];
const heads = ['active', 'Правило', 'Описание', 'Роли']; // use aliases for ui-->name and ruleName --> description
const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${key}`;

const UISettingsConf = React.memo(() => {
    return <CommonInterfaceConfig className={style.ui_settings_conf}
                                  renders={
                                      {
                                          'active': (props) => <Label {...props}/>,
                                          'ui': (props) => <Strong {...props}/>,
                                      }
                                  }
                                  schema={schema}
                                  settingsKey={settingsKey}
                                  body={body}
                                  heads={heads}
                                  sortedBy={keys[1]}/>;
});

export default UISettingsConf;
