import React from 'react';

import { Dict } from '../../../types';
import { numberToTimeFormat } from '../../ui/FormatDate';
import { LabelStatus, TLabel } from '../../ui/Table';
import style from './renders.css';

export interface TBodyItemProps {
    item: any;
    index;
    bodyItem: string;
    renders?: Dict<any>;
    raw?: any;
}

export const Label = (props: TBodyItemProps) => {
    return props?.item
        ? <TLabel status={LabelStatus.INFO} text={'enabled'}/>
        : <TLabel status={LabelStatus.DEFAULT} text={'disabled'}/>;
};

export const ChatType = (props: TBodyItemProps) => {
    return props.item === 'chats'
        ? <TLabel status={LabelStatus.WARNING} text={props.item}/>
        : <TLabel status={LabelStatus.POSITIVE} text={props.item}/>;
};

export const Color = (props: TBodyItemProps) => {
    return <TLabel status={LabelStatus.DEFAULT}
                   text={'color'}
                   style={{ backgroundColor: props.item }}/>;
};

export const ArrayText = (props: TBodyItemProps) => {
    return <>{props?.item && Array.isArray(props.item) && props?.item?.join(', ')}</> || <span/>;
};

export const TimeText = (props: TBodyItemProps) => {
    return <div>{numberToTimeFormat(props.item)}</div>;
};

export const Strong = (props: TBodyItemProps) => {
    return <strong>{props.item}</strong>;
};

export const ShortText = (props: TBodyItemProps) => {
    return <span className={style.short} title={props.item}>{props.item}</span>;
};
