import React from 'react';

import { Dict } from '../../../../types';
import * as tblStyle from '../../../ui/Table/index.css';
import { Request2 } from '../../../utils/request';
import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import style from './index.css';
import { requestConfigs, REQUESTS } from './request';

export default class LeasingStats extends React.Component<any, any> {
    request = new Request2({ requestConfigs });
    state = {
        isLoading: false,
        error: null,
        response: {},
    };

    componentWillUnmount() {
        this.request.abort();
    }

    componentDidMount() {
        this.getData();
    }

    getData() {
        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_CARS)
                .then(response => {
                    this.setState({
                        isLoading: false,
                        response,
                    });
                })
                .catch(error => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    render() {
        return <div>{
            this.state.isLoading
                ? <Spin/>
                : this.state.error
                    ? <SimpleError error={this.state.error}/>
                    : <Stat1 response={this.state.response}/>
        }</div>;
    }
}

const Stat1 = ({ response }) => {
    const { cars } = response;

    const obj: Dict<{ cars: any[]; tag: any }> = cars?.reduce((_p, _c) => {
        const { tags } = _c;
        /*if (!tags.some(el => el.tag === 'leasing_stats')) {
            return _p;
        }*/
        tags?.forEach(el => {
            if (!_p.hasOwnProperty(el.tag)) {
                _p[el.tag] = {
                    tag: el,
                    cars: [_c],
                };
            } else {
                _p[el.tag].cars.push(_c);
            }
        });

        return _p;
    }, {}) || {};

    const allTags = Object.entries(obj).sort((a, b) => {
        return b[1].cars.length - a[1].cars.length;
    });

    return <div>
        <div>Всего загружено машин: <strong>{cars?.length}</strong>, из них cо
            статистикой: <strong>{statFilter(cars)}</strong></div>
        <div>Всего тегов: {allTags.length}</div>
        <table className={`${tblStyle.table} ${tblStyle.clearFirstOpacity}`}>
            <thead>
                <tr>
                    <th>всего машин</th>
                    <th>leasing_stats</th>
                    <th>тег</th>
                </tr>
            </thead>
            <tbody>
                {
                    allTags.map((_tag, index) => {
                        const { cars = [], tag = {} } = _tag?.[1];
                        const key = _tag?.[0] || '';

                        return <tr key={key}>
                            <td>{cars?.length}</td>
                            <td>{statFilter(cars)}</td>
                            <td>
                                <div className={style.display_name}>{tag?.display_name}</div>
                                <div className={style.tag}>{key}</div>
                            </td>
                        </tr>;
                    })
                }
            </tbody>
        </table>
    </div>;
};

const statFilter = (cars) => {
    return cars?.filter(car => car?.tags.filter(el => el.tag === 'leasing_stats').length)?.length;
};
