import * as React from 'react';

import { LOCALIZATION_RESOURCE_PREFIX } from '../../../constants';
import { Link } from '../../../ui/Link';
import { INavigationRouteItem } from '../../../utils/navigation';
import { Translate } from '../../../utils/translate';
import style from './index.css';

export interface IMenuItem {
    href: string;
    uri: string | React.ReactElement;
    tabs?: INavigationRouteItem[];
    toggleMenu: (state?: boolean) => void;
    t: Translate;
    filterValue: string;
    resetFilterValue: () => void;
}

export class MenuItem extends React.Component<IMenuItem, any> {

    click() {
        this.props.toggleMenu();
        this.props.resetFilterValue();
    }

    includesTab(targetString: string) {
        return targetString.toLocaleLowerCase().trim().includes(this.props.filterValue.toLocaleLowerCase().trim());
    }

    highlightFoundValue(field: string | object) {
        const filterValue = this.props.filterValue.trim().toLocaleLowerCase();
        const filterFoundIndex: number = field.toString().toLowerCase().indexOf(filterValue);
        if (typeof field === 'string') {
            return filterFoundIndex > -1
                ? <span>
                    {field.substring(0, filterFoundIndex)}
                    <span className={style.found}>
                        {field.substring(filterFoundIndex, filterFoundIndex + filterValue.length)}
                    </span>
                    {field.substring(filterFoundIndex + filterValue.length)}
                </span>
                : field;
        }

        return field;

    }

    render() {
        const { t, uri } = this.props;

        const filteredTabs = this.props.tabs
            ? this.props.tabs
                .sort((a, b) => a.order - b.order)
                .filter((tab, index) => {
                    const tabName = t.getItem(LOCALIZATION_RESOURCE_PREFIX + tab.uri);

                    return this.includesTab(tabName.toString());
                })
            : [];

        return <div>
            {
                (this.includesTab(t.getItem(LOCALIZATION_RESOURCE_PREFIX + uri).toString()) || filteredTabs?.length > 0)
                    ? <Link onClick={this.click.bind(this)}
                            className={style['menu-item']}
                            href={this.props.href}
                            disablePreventDefault>
                        {this.highlightFoundValue(t.getItem(LOCALIZATION_RESOURCE_PREFIX + uri))}
                    </Link>
                    : null
            }
            {
                filteredTabs.map((tab, index) =>
                    <Link key={index}
                          onClick={this.click.bind(this)}
                          className={style['menu-sub-item']}
                          href={`${this.props.href}/${tab.uri}`}
                          disablePreventDefault>
                        {this.highlightFoundValue(t.getItem(LOCALIZATION_RESOURCE_PREFIX + tab.uri))}
                    </Link>,
                )
            }
        </div>;
    }
}
