import * as React from 'react';
import { RefObject } from 'react';

import { LocalizationReducerState } from '../../reducers/localizationReducer';
import { Input } from '../../ui/Input';
import { CreateLeftMenuItems } from '../../utils/CreateLeftMenuItems';
import { Translate } from '../../utils/translate';
import { AbstractMenuSideBar, IPropsUserMenu } from '../Menu';
import style from '../Menu/index.css';
import { ILeftMenuMapStateToProps } from './index';
import { MenuItem } from './MenuItem';

export interface IProps extends IPropsUserMenu, ILeftMenuMapStateToProps {
}

export class LeftMenu extends React.PureComponent<IProps> {

    inputRef: RefObject<Input> | null = null;

    constructor(props) {
        super(props);
        this.inputRef = React.createRef();
    }

    state = {
        value: '',
    };

    componentDidUpdate(prevProps: Readonly<IProps>, prevState: Readonly<{}>, snapshot?: any) {
        if (this.props.active && (this.props.active !== prevProps.active)) {
            this.inputRef?.current?.onContainerFocus?.();
        }
    }

    onChange(value) {
        this.setState({
            value: value,
        });
    }

    resetFilterValue() {
        this.setState({
            value: '',
        });
    }

    render() {
        const {
            rules = {}, Lang = {} as LocalizationReducerState, active = false, toggleSideBar = () => {
            },
        } = this.props;
        const t = new Translate(Lang);

        return <AbstractMenuSideBar active={active}
                                    menuId={'menu-main'}
                                    toggleSideBar={toggleSideBar}>
            {active && <div className={style.left_side}>
                <Input value={this.state.value}
                       onChange={this.onChange.bind(this)}
                       placeholder={'Фильтр'}
                       dontShowPlaceholderIfFocused
                       className={style.searchInput}
                       ref={this.inputRef}/>
                <MenuItem href={'#'}
                          uri={'home'}
                          toggleMenu={toggleSideBar}
                          t={t}
                          filterValue={this.state.value}
                          resetFilterValue={this.resetFilterValue.bind(this)}/>
                <CreateLeftMenuItems rules={rules}
                                     toggleMenu={toggleSideBar}
                                     t={t}
                                     filterValue={this.state.value}
                                     resetFilterValue={this.resetFilterValue.bind(this)}/>
            </div>}
        </AbstractMenuSideBar>;
    }

}
