import { connect } from 'react-redux';

import { IRuleState } from '../../reducers/adminUserReducer';
import { LocalizationReducerState } from '../../reducers/localizationReducer';
import { IStore } from '../App/store';
import { LeftMenu } from './component';

export interface ILeftMenuMapStateToProps {
    rules: IRuleState | undefined;
    Lang: LocalizationReducerState | undefined;
}

export const mapStateToProps = (store: IStore): ILeftMenuMapStateToProps => {
    return {
        rules: store.AdminUser?.rules,
        Lang: store.Lang,
    };
};

export default connect(mapStateToProps)(LeftMenu);
