import * as React from 'react';

import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import * as styles from '../index.css';
import { TActionType } from '../types';

const RESPONSE = {
    'confirm': 'принято',
    'reject': 'отклонено',
};

interface ILiteConfirmationActionDone {
    error: Error | null;
    actionType: TActionType;
    isLoading: boolean;
}

export const LiteConfirmationActionDone = (props: ILiteConfirmationActionDone) => {
    const { error, actionType, isLoading } = props;

    return <div className={styles.actionDoneContainer}>
        {error
            ? <SimpleError error={error}/>
            : isLoading
                ? <p className={styles.actionDoneContent}>
                    Предложение обрабатывается <Spin size={'s'}/>
                </p>
                : actionType
                    ? <p className={styles.actionDoneContent}>
                        Предложение {RESPONSE[actionType]} успешно!
                    </p>
                    : null
        }
    </div>;
};

LiteConfirmationActionDone.displayName = 'LiteConfirmationActionDone';
