import * as React from 'react';

import { NoInformation } from '../../../ui/NoInformation';
import { isObjectEqual } from '../../../utils/isObjectEqual';
import { LiteConfirmationsItem } from '../LiteConfirmationsItem';
import { IDiffActionsRoles, ILCData } from '../types';

const ENTITY = {
    'action': 'экшен',
    'role': 'роль',
};

interface ILiteConfirmationsInterfaceProps {
    data: ILCData | null;
    diffActionsRoles?: IDiffActionsRoles;
}

export const LiteConfirmationsInterface = React.memo((props: ILiteConfirmationsInterfaceProps) => {
    const { data,diffActionsRoles } = props;

    return <>
        {data && <div>
            <h1>{ENTITY[data.type]}: {data.id}</h1>
            <p>
                <strong>Описание: </strong>
                {data.description}
            </p>
            {!data?.propositions || !data?.propositions?.length
                ? <NoInformation/>
                : data?.propositions?.map((proposition, index) => {
                    return <LiteConfirmationsItem key={index}
                                                  proposition={proposition}
                                                  diffActionsRoles={diffActionsRoles}/>;
                })
            }
        </div>}
    </>;
}, (prevProps, nextProps) => {
    return isObjectEqual(prevProps.data, nextProps.data);
});

LiteConfirmationsInterface.displayName = 'LiteConfirmationsInterface';
