import * as React from 'react';

import { Dict } from '../../../../types';
import { EMPTY_DATA } from '../../../constants';
import { Link } from '../../../ui/Link';

interface ILiteConfirmationsItemDiff {
    diff: Dict<unknown>;
}

const SUBSTR_LIMIT = 50;
export const manipulateDiff = (value, returnFull = false) => {
    let limit = SUBSTR_LIMIT;
    const space = 2;
    if (value && typeof value === 'object') {
        value = JSON.stringify(value, null, returnFull ? space : 0);
    }

    if (typeof value === 'boolean' || typeof value === 'number') {
        value = value?.toString() ?? null;
    }

    if (returnFull) {
        limit = value?.length;
    }

    return value ? `${value?.substring(0, limit)}` : null;
};

export const LiteConfirmationsItemDiff = React.memo((props: ILiteConfirmationsItemDiff) => {
    let fullText = manipulateDiff(props.diff, true);
    let minText = manipulateDiff(props.diff);
    const [diffText, setDiffText] = React.useState(minText);

    React.useEffect(() => {
        fullText = manipulateDiff(props.diff, true);
        minText = manipulateDiff(props.diff);
        setDiffText(minText);
    }, [props.diff]);

    return <pre>
        {diffText ?? EMPTY_DATA}
        {fullText && minText && fullText?.length > minText?.length
            ? <Link onClick={() => {
                if (minText?.length === diffText?.length) {
                    setDiffText(fullText);
                } else {
                    setDiffText(minText);
                }
            }}>
                [{minText?.length === diffText?.length ? '...' : 'свернуть'}]
            </Link>
            : null
        }
    </pre>;
});

LiteConfirmationsItemDiff.displayName = 'LiteConfirmationsItemDiff';
