import * as React from 'react';

import { Request2 } from '../../utils/request';
import { deepCopy } from '../../utils/utils';
import { wrapContentId } from '../Content/types';
import { SimpleError } from '../SimpleError';
import Spin from '../Spin';
import * as styles from './index.css';
import { LiteConfirmationActionDone } from './LiteConfirmationsActionDone';
import { LiteConfirmationsGetData } from './liteConfirmationsGetData';
import { LiteConfirmationsInterface } from './LiteConfirmationsInterface';
import { LITE_CONFIRMATIONS_REQUESTS, REQUESTS } from './request';
import { IDiffActionsRoles, RolesActionDiff, TActionType, TConfirmationType } from './types';

interface ILiteConfirmationsProps {
    location: any;
}

const RolesActionDiffInit = { A: { roles: [], actions: [] }, R: { roles: [], actions: [] } };

const diffAR = (response) => {
    const A: RolesActionDiff = deepCopy(RolesActionDiffInit.A);
    const R: RolesActionDiff = deepCopy(RolesActionDiffInit.R);
    const role_id = response?.report?.[0]?.role_id;
    const proposition = response?.propositions?.find(el => el.role_id === role_id);
    const role = response?.report?.[0];

    role?.actions?.forEach(el => {
        const isContain = proposition?.actions?.some(el2 => el2.action_id === el.action_id);
        if (!isContain) {
            R.actions.push(el?.action_id);
        }
    });
    proposition?.actions?.forEach(el => {
        const isContain = role?.actions?.some(el2 => el2.action_id === el.action_id);
        if (!isContain) {
            A.actions.push(el?.action_id);
        }
    });

    role?.slave_roles?.forEach(el => {
        const isContain = proposition?.slave_roles?.some(el2 => el2.slave_role_id === el.slave_role_id);
        if (!isContain) {
            R.roles.push(el?.slave_role_id);
        }
    });

    proposition?.slave_roles?.forEach(el => {
        const isContain = role?.slave_roles?.some(el2 => el2.slave_role_id === el.slave_role_id);
        if (!isContain) {
            A.roles.push(el?.slave_role_id);
        }
    });

    return {
        A,
        R,
    };
};

export const LiteConfirmations = (props: ILiteConfirmationsProps) => {
    const { location } = props;
    const request = new Request2({ requestConfigs: LITE_CONFIRMATIONS_REQUESTS });
    const [data, setData] = React.useState(null);
    const [fetchError, setFetchError] = React.useState<Error | null>(null);
    const [isLoading, setLoading] = React.useState<boolean>(true);
    const [actionType, setActionType] = React.useState<TActionType>(null);
    const [actionError, setActionError] = React.useState<Error | null>(null);
    const [isActionWorking, setActionWorking] = React.useState<boolean>(false);
    const [diffActionsRoles, setDiffAR] = React.useState<IDiffActionsRoles>(deepCopy(RolesActionDiffInit));

    React.useEffect(() => {
        const query = new URLSearchParams(location.search);
        const id = query.get('id');
        const type: TConfirmationType = query.get('type') as TConfirmationType;
        if (type && id) {
            setDiffAR(deepCopy(RolesActionDiffInit));
            request.exec(REQUESTS[`GET_${type.toUpperCase()}`], {
                queryParams: {
                    [`${type}_id`]: id,
                },
            })
                .then((response) => {
                    const buildPropositionAction = (_proposition_id, type: TConfirmationType) => {
                        return (actionType: TActionType, disableButtons) => {
                            setActionWorking(true);
                            setActionError(null);
                            document.getElementById(wrapContentId)?.scrollTo(0, 0);

                            request.exec(REQUESTS[`${type?.toUpperCase()}_${actionType?.toUpperCase()}`], {
                                body: {
                                    proposition_ids: [_proposition_id],
                                },
                            })
                                .then(() => {
                                    setActionType(actionType);
                                    disableButtons(true);
                                    setActionWorking(false);
                                })
                                .catch((raw_error) => {
                                    let error = raw_error;
                                    if (error?.data?.error_details?.special_info?.session_info
                                        ?.hasOwnProperty('self confirm is denied')) {
                                        error = new Error('Нельзя подтверждать свои же предложения :(');
                                    }

                                    setActionError(error);
                                });
                        };
                    };

                    setDiffAR(diffAR(response));
                    const data = LiteConfirmationsGetData(response, type, buildPropositionAction, id);
                    if (data) {
                        setData(data);
                    } else {
                        setFetchError(new Error('Получение данных невозможно. Проверьте id сущности и ее тип'));
                    }

                    setLoading(false);
                })
                .catch((error) => {
                    setFetchError(error);
                    setLoading(false);
                });
        } else {
            setFetchError(new Error('Получение данных невозможно. Проверьте id сущности и ее тип'));
            setLoading(false);
        }
    }, [location]);

    return <div className={styles.container}>
        {actionType || isActionWorking || actionError
            ? <LiteConfirmationActionDone error={actionError}
                                          actionType={actionType}
                                          isLoading={isActionWorking}/>
            : null
        }
        {fetchError
            ? <SimpleError error={fetchError}/>
            : isLoading
                ? <Spin/>
                : <LiteConfirmationsInterface data={data}
                                              diffActionsRoles={diffActionsRoles}/>
        }
    </div>;
};
