import { EMPTY_DATA, ONE_SECOND } from '../../constants';
import { dateLag } from '../../ui/FormatDate';
import { buildDiff } from './buildDiff';
import { ConfirmationType, ILCData, TActionType, TBuildPropositionAction, TConfirmationType } from './types';

const buildDataAction = (
    response,
    buildPropositionAction: TBuildPropositionAction,
    entityId: string | null,
): ILCData | null => {
    const reportData = response?.report?.filter((_action) => _action.action_id === entityId)?.[0];
    const propositionData = reportData?.propositions;

    if (reportData || propositionData?.length) {
        const description = reportData?.action_description ?? propositionData?.[0]?.action_description;
        const id = reportData?.action_id ?? propositionData?.[0]?.action_id;
        const propositions = propositionData?.map((_proposition) => {
            const historyInstant = _proposition?.confirmations?.[0]?.history_instant * ONE_SECOND;
            const authorUserId = _proposition?.confirmations?.[0]?.user_id;
            const author = response?.proposition_users?.find(user => user.id === authorUserId);
            const propositionAction = buildPropositionAction(_proposition?.proposition_id, ConfirmationType.ACTION);

            return {
                propositionAction,
                historyInstant,
                historyInstantLag: dateLag(historyInstant),
                description: _proposition?.proposition_description ?? EMPTY_DATA,
                author,
                diff: buildDiff(reportData, _proposition),
            };
        }) ?? [];

        return {
            id,
            description,
            type: ConfirmationType.ACTION,
            propositions,
        };
    }

    return null;
};

const buildDataRole = (
    response,
    buildPropositionAction: TBuildPropositionAction,
    entityId: string | null,
): ILCData | null => {
    const reportData = response?.report?.[0];
    const propositionData = response?.propositions?.filter((_proposition) => _proposition.role_id === entityId);

    if (reportData || propositionData.length) {
        const description = reportData?.role_description ?? propositionData?.[0]?.role_description;
        const id = reportData?.role_id ?? propositionData?.[0]?.role_id;
        const propositions = propositionData?.map((_proposition) => {
            const historyInstant = _proposition?.confirmations?.[0]?.history_instant * ONE_SECOND;
            const author_user_id = _proposition?.confirmations[0]?.user_id;
            const author = response?.users[author_user_id];
            const propositionAction = buildPropositionAction(_proposition?.proposition_id, ConfirmationType.ROLE);

            return {
                propositionAction,
                historyInstant,
                historyInstantLag: dateLag(historyInstant),
                description: _proposition?.proposition_description ?? EMPTY_DATA,
                author,
                diff: buildDiff(reportData, _proposition),
            };
        }) ?? [];

        return {
            id,
            description,
            type: ConfirmationType.ROLE,
            propositions,
        };
    }

    return null;
};

export const LiteConfirmationsGetData = (
    response,
    type: TConfirmationType,
    buildPropositionAction: (
        propositionId: string,
        type: TConfirmationType,
    ) => (actionType: TActionType, disableButtons) => void,
    entityId: string | null,
): any => {
    if (type === ConfirmationType.ACTION) {
        return buildDataAction(response, buildPropositionAction, entityId);
    }

    if (type === ConfirmationType.ROLE) {
        return buildDataRole(response, buildPropositionAction, entityId);
    }
};
