import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_ACTION = 'GET_ACTION',
    GET_ROLE = 'GET_ROLE',
    ROLE_REJECT = 'ROLE_REJECT',
    ROLE_CONFIRM = 'ROLE_CONFIRM',
    ACTION_CONFIRM = 'ACTION_CONFIRM',
    ACTION_REJECT = 'ACTION_REJECT'
}

export const LITE_CONFIRMATIONS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_ACTION]: {
        api: 'actions/list',
        cgiObj: {
            action_id: null,
        },
    },
    [REQUESTS.GET_ROLE]: {
        api: 'roles/list',
        cgiObj: {
            role_id: null,
        },
    },
    [REQUESTS.ROLE_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/snapshot/reject',
    },
    [REQUESTS.ROLE_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'roles/snapshot/confirm',
    },
    [REQUESTS.ACTION_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/confirm',
    },
    [REQUESTS.ACTION_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'actions/reject',
    },
};
