import UserInfo from '../../models/user';

export enum ConfirmationType {
    ACTION = 'action',
    ROLE = 'role'
}

export enum ActionType {
    CONFIRM = 'confirm',
    REJECT = 'reject'
}

export type TConfirmationType = ConfirmationType | null;
export type TActionType = ActionType | null;
export type TPropositionAction = (actionType: TActionType, disableButtons) => void;
export type TBuildPropositionAction = (propositionId: string, type: TConfirmationType) => TPropositionAction;

export interface ILCProposition {
    propositionAction: TPropositionAction;
    historyInstant: number;
    historyInstantLag: string;
    description: string;
    author: UserInfo;
    diff: any;
}

export interface ILCData {
    id: string;
    description: string;
    type: ConfirmationType;
    propositions: ILCProposition[];
}

export interface RolesActionDiff {
    roles: string[];
    actions: string[];
}

export interface IDiffActionsRoles {
    A: RolesActionDiff;
    R: RolesActionDiff;
}
