import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_LOCALIZATIONS = 'GET_LOCALIZATIONS',
    REMOVE_LOCALIZATIONS = 'REMOVE_LOCALIZATIONS',
    UPSERT_LOCALIZATIONS = 'UPSERT_LOCALIZATIONS',
    LOCALIZATIONS_PROPOSE = 'LOCALIZATIONS_PROPOSE',
    LOCALIZATIONS_REJECT = 'LOCALIZATIONS_REJECT',
    LOCALIZATIONS_CONFIRM = 'LOCALIZATIONS_CONFIRM',
    GET_PROPOSITIONS = 'GET_PROPOSITIONS',
}

export const CORE_DRIVE_LENS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_LOCALIZATIONS]: {
        api: 'localization/info',
        cgiObj: { id: null },
    },
    [REQUESTS.REMOVE_LOCALIZATIONS]: {
        method: REQUEST_METHOD.POST,
        api: 'localization/remove',
    },
    [REQUESTS.UPSERT_LOCALIZATIONS]: {
        method: REQUEST_METHOD.POST,
        api: 'localization/upsert',
    },
    [REQUESTS.LOCALIZATIONS_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: 'localization/propose',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.LOCALIZATIONS_REJECT]: {
        method: REQUEST_METHOD.POST,
        api: 'localization/reject',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.LOCALIZATIONS_CONFIRM]: {
        method: REQUEST_METHOD.POST,
        api: 'localization/confirm',
        cgiObj: {
            comment: null,
        },
    },
    [REQUESTS.GET_PROPOSITIONS]: {
        api: 'localization/propositions',
    },
};
