import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_LOCALIZATIONS = 'GET_LOCALIZATIONS',
    REMOVE_LOCALIZATIONS = 'REMOVE_LOCALIZATIONS',
    UPSERT_LOCALIZATIONS = 'UPSERT_LOCALIZATIONS',
}

export const CORE_DRIVE_LENS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_LOCALIZATIONS]: {
        api: 'localization/info',
        cgiObj: { id: null },
    },
    [REQUESTS.REMOVE_LOCALIZATIONS]: {
        method: REQUEST_METHOD.POST,
        api: 'localization/remove',
    }, [REQUESTS.UPSERT_LOCALIZATIONS]: {
        method: REQUEST_METHOD.POST,
        api: 'localization/upsert',
    },
};
