/*eslint-disable*/
import React from 'react';
import Checkbox from '../../../ui/Checkbox';
import { CAR_COLORS } from '../../../constants';
import style from './index.css';

const Pin = (props) => {
    const {color, className} = props;
    return <div className={className} style={{backgroundColor: `#${color.toString(16)}`}}/>;
};

const Filter = (props) => {
    const {
        type,
        itemList,
        handleFilterClick,
        currentFilters,
        handleChangeColorSource,
        colorSource,
        numberCars
    } = props;

    return <div className={style.filter}>
        {handleChangeColorSource &&
        <div className={style.filter__checkbox}>{type}
            <Checkbox checked={type === colorSource} onChange={handleChangeColorSource.bind(null, type)}/>
        </div>}
        <div
            className={style.filter__title + (!currentFilters[type] ? ' ' + style.filter__title_active : '')}
            onClick={currentFilters[type] ? handleFilterClick.bind(null, null, type) : null}
        >
            <div>Всего</div>
            {numberCars}
        </div>
        {Object.keys(itemList).sort((a, b) => a.localeCompare(b))
            .map((key, index) =>
                <div
                    key={index}
                    className={style.item + (currentFilters[type] === key ? ' ' + style.item__active : '')}
                    onClick={(currentFilters[type] !== key) ? handleFilterClick.bind(null, key, type) : null}
                >
                    <div className={style.item__title}>
                        {CAR_COLORS[key] && <Pin className={style.item__pin} color={CAR_COLORS[key]}/>}
                        <div className={style.item__text} title={key}>{key}</div>
                    </div>
                    <div className={style.item__number}>{itemList[key]}</div>
                </div>
            )}
    </div>;
};

export default Filter;
