import React, { useState } from 'react';

import TriangleIcon from '../../../../svg-components/triangle.component.svg';
import Filter from '../Filter';
import OffersFilter from '../OffersFilter';
import style from './index.css';

const Legend = (props) => {
    const {
        statuses,
        models,
        offers,
        idles,
        /*     kffs,*/
        handleCarsFilterClick,
        filter,
        isShowCars,
        showCars,
        showClusters,
        handleChangeColorSource,
        colorSource,
        numberCars,
    } = props;

    const [filtersIsOpen, setOpenFilters] = useState(false);

    const toggleFilters = () => {
        setOpenFilters(!filtersIsOpen);
    };

    return <>
        <div className={style.controls}>
            <div className={style.controls__item + (isShowCars ? '' : ' ' + style.controls__item_active)}
                 onClick={showClusters}
                 children={'Машины'}/>
            <div className={style.controls__item + (isShowCars ? ' ' + style.controls__item_active : '')}
                 onClick={showCars}
                 children={'Тепловая карта'}/>
        </div>

        <div style={{ display: filtersIsOpen ? 'none' : 'block' }}
             className={style.filters__icon}
             onClick={numberCars ? toggleFilters : undefined}/>

        <div className={style.filters + ' ' + style.filters__right + (filtersIsOpen ? '' : ' ' + style.filters_invisible)}>
            <TriangleIcon className={style.filters__close + ' ' + style.filters__close_right}
                          onClick={toggleFilters}/>
            <div className={style.filters__container}>
                <Filter numberCars={numberCars}
                        type={'status'}
                        itemList={statuses}
                        handleFilterClick={handleCarsFilterClick}
                        currentFilters={filter.currentFilters}/>

                <Filter type={'model_id'}
                        itemList={models}
                        handleFilterClick={handleCarsFilterClick}
                        currentFilters={filter.currentFilters}/>
            </div>
        </div>
        <div className={style.filters + ' ' + style.filters__left + (filtersIsOpen ? '' : ' ' + style.filters_invisible)}>
            <TriangleIcon className={style.filters__close + ' ' + style.filters__close_left}
                          onClick={toggleFilters}/>
            <div className={style.filters__container}>
                <OffersFilter offers={offers}
                              selectItem={handleCarsFilterClick}
                              currentFilters={filter.currentFilters}/>
                <Filter type={'__idle'}
                        itemList={idles}
                        handleFilterClick={handleCarsFilterClick}
                        currentFilters={filter.currentFilters}
                        handleChangeColorSource={handleChangeColorSource}
                        colorSource={colorSource}/>
                {/* <Filter
                    type={'__kff'}
                    itemList={kffs}
                    handleFilterClick={handleCarsFilterClick}
                    currentFilters={filter.currentFilters}
                    handleChangeColorSource={handleChangeColorSource}
                    colorSource={colorSource}
                />*/}
            </div>
        </div>
    </>;
};

export default Legend;
