// import React from 'react';
// import { render } from 'react-dom';
// import * as THREE from 'three';
// import { BufferGeometryUtils } from 'three/examples/jsm/utils/BufferGeometryUtils';
// import { CAR_COLORS, EMPTY_DATA, GEO_POINTS, MAGIC_ZOOM } from '../../../constants';
// // @ts-ignore
// import jsonFont from './font_helvetiker_regular.json';
// import LS from '../../../utils/localStorage';
// import { debounce } from '../../../utils/utils';
// import { ICar, IFuelStation, IPoly, LSSettingItems } from '../../../../types';
// import { initMap } from '../utils';
// import style from './index.css';
// import { IBlockRules } from '../../Clients/UserInfoView/component';
// import CarsFilter from '../CarsFilters/index';
// import { CarTooltip } from '../CarTooltip';
//
// declare let ymaps: any;
//
// interface IMapCanvasProps extends IBlockRules {
//     colorSource: string,
//     isShowCars: boolean,
//     cars: ICar[],
//     filter: {},
//     handleCarsFilterClick: (key: string, type: string | null) => void,
//     modelsData: {},
//     showPoly: boolean,
//     poly: IPoly[],
//     polyFiltering: (filter: any) => Promise<any>,
//     getFueling: (isShow: boolean) => void,
//     fuelStations: IFuelStation[],
//     mapIsReady: () => void,
//     polyFilters: any,
// }
//
// class MapCanvas extends React.Component<IMapCanvasProps> {
//     state = {
//         carsFiltersIsOpen: false
//     };
//     ls = new LS();
//
//     map;
//     zoom: number = 10;
//     mapContainer;
//     cursor;
//     width;
//     height;
//     projection;
//     mapGlobalPixelCenter;
//     globalPixelCenter;
//     preCenter;
//
//     threeRootElement;
//     scene;
//     camera;
//     renderer;
//     raycaster;
//
//     mouseDown = {x: 0, y: 0, isDown: false};
//
//     carPoints;
//     fuelStationsPoints;
//
//     colorSource;
//
//     cars: any = [];
//     fuelStations;
//     modelsData;
//     clusters: any = [];
//     clusterKeys: string[] = [];
//     poly: IPoly[] = [];
//     isZoomCluster = false;
//     currentCar = {} as any;
//     carTooltip: any = {};
//     polyTooltip;
//     fuelTooltip: any = {};
//
//     hoverContainer;
//
//     componentDidMount(): void {
//         initMap('map', (map) => {
//             this.map = map;
//             this.projection = this.map && this.map.options.get('projection');
//             const mapSize = this.map && this.map.container.getSize() || [];
//             this.width = mapSize[0];
//             this.height = mapSize[1];
//             this.cursor = this.map && this.map.cursors.push('grab');
//             this.mapGlobalPixelCenter = this.map && this.map.getGlobalPixelCenter();
//             this.globalPixelCenter = this.mapGlobalPixelCenter;
//             this.initControls();
//             this.initCanvas();
//             this.initListener();
//             this.initCarTooltip();
//             this.initFuelStationTooltip();
//         });
//     }
//
//     componentWillUnmount(): void {
//         this.map && this.map.destroy();
//     }
//
//     shouldComponentUpdate(nextProps: Readonly<IMapCanvasProps>, nextState): boolean {
//         this.clearThree(this.scene && this.scene);
//         this.cars = nextProps.cars;
//         this.modelsData = nextProps.modelsData;
//         this.colorSource = nextProps.colorSource;
//         if (nextProps.showPoly) {
//             this.poly = nextProps.poly;
//             this.getGlobalPositionForPoly(this.zoom);
//         }
//         if (nextProps.isShowCars) {
//             this.drawCars();
//         } else {
//             this.clustering(this.zoom);
//         }
//         if (nextProps.fuelStations.length) {
//             this.fuelStations = nextProps.fuelStations;
//             this.drawFuelStations();
//         }
//         if (this.state.carsFiltersIsOpen !== nextState.carsFiltersIsOpen) {
//             return true;
//         }
//         return false;
//     }
//
//     initControls() {
//         const zoomControl = new ymaps.control.ZoomControl({
//             options: {
//                 size: 'small'
//             }
//         });
//         this.map.controls.add(zoomControl);
//
//         const searchControl = new ymaps.control.SearchControl();
//
//         const fuelStations = new ymaps.control.Button({
//             data: {
//                 content: 'Заправки'
//             }
//         });
//
//         const showAll = new ymaps.control.Button({
//             data: {
//                 content: 'Вместить все'
//             }
//         });
//
//         if (this.props.polyFilters) {
//             const polyList = Object.keys(this.props.polyFilters)
//                 .filter((keyPoly) => {
//                     if (this.props.polyFilters[keyPoly]?.blockrules?.length) {
//                         return this.props.polyFilters[keyPoly].blockrules.some((rule) => this.props.BlockRules?.[rule]);
//                     } else {
//                         return true;
//                     }
//                 })
//                 .map(keyPoly => {
//                     return new ymaps.control.ListBoxItem({
//                         data: {
//                             content: this.props.polyFilters[keyPoly].name
//                         },
//                         state: {
//                             selected: false,
//                             keyPoly
//                         }
//                     });
//                 });
//
//             const poly = new ymaps.control.ListBox({
//                 data: {
//                     content: 'Полигоны'
//                 },
//                 items: polyList
//             });
//
//             poly.events.add(['select'], e => {
//                 const current = e.get('target').state.get('keyPoly');
//                 const iterator = poly.getIterator();
//                 let obj;
//                 while ((obj = iterator.getNext()) !== iterator.STOP_ITERATION) {
//                     obj.disable();
//                     if (obj.state.get('keyPoly') !== current) {
//                         obj.deselect();
//                     }
//                 }
//                 this.props.polyFiltering(this.props.polyFilters[current]).then(() => {
//                     const iterator = poly.getIterator();
//                     while ((obj = iterator.getNext()) != iterator.STOP_ITERATION) {
//                         obj.enable();
//                     }
//                 });
//             });
//
//             poly.events.add(['deselect'], () => {
//                 this.props.polyFiltering(null);
//             });
//
//             this.map.controls.add(poly, {float: 'right'});
//         }
//
//         const cityList = [
//             new ymaps.control.ListBoxItem({
//                 data: {content: 'Все города'}, state: {selected: false, keyCity: null}
//             }),
//             ...Object.keys(GEO_POINTS).map(keyCity => {
//                 return new ymaps.control.ListBoxItem({
//                     data: {content: GEO_POINTS[keyCity].LABEL.normal},
//                     state: {selected: false, keyCity}
//                 });
//             })];
//
//         const city = new ymaps.control.ListBox({
//             data: {
//                 content: 'Города'
//             },
//             items: cityList
//         });
//
//         city.events.add(['select'], e => {
//             const current = e.get('target').state.get('keyCity');
//             const iterator = city.getIterator();
//             let obj;
//             while ((obj = iterator.getNext()) !== iterator.STOP_ITERATION) {
//                 if (obj.state.get('keyCity') !== current) {
//                     obj.deselect();
//                 }
//             }
//             this.props.handleCarsFilterClick(current, '__city');
//             this.saveCity(current);
//         });
//
//         showAll.events.add('select', () => {
//             this.map.setBounds(this.getBounds());
//             showAll.deselect();
//         });
//
//         fuelStations.events.add('select', () => {
//             this.props.getFueling(true);
//         });
//
//         fuelStations.events.add(['deselect'], () => {
//             this.props.getFueling(false);
//         });
//
//         const filtersCars = new ymaps.control.Button({
//             data: {content: 'Фильтры / Машины'},
//             options: {
//                 maxWidth: [150, 178]
//             }
//         });
//
//         filtersCars.events
//             .add('select', () => {
//                 this.setState({carsFiltersIsOpen: true});
//                 filtersCars.deselect();
//             });
//
//         this.map.controls.add(fuelStations, {float: 'right'});
//         this.map.controls.add(showAll, {float: 'right'});
//         this.map.controls.add(city, {float: 'right'});
//         this.map.controls.add(searchControl, {float: 'right',});
//         this.map.controls.add(filtersCars, {float: 'right'});
//     }
//
//     getBounds() {
//         let minX = Infinity;
//         let maxX = -Infinity;
//         let minY = Infinity;
//         let maxY = -Infinity;
//         this.cars.forEach(car => {
//             minX = Math.min(car.location.lat, minX);
//             maxX = Math.max(car.location.lat, maxX);
//             minY = Math.min(car.location.lon, minY);
//             maxY = Math.max(car.location.lon, maxY);
//         });
//         return [[minY, minX], [maxY, maxX]];
//     }
//
//     saveCity(city) {
//         if (city) {
//             this.map.setCenter(GEO_POINTS[city].OPTIONS.center, GEO_POINTS[city].OPTIONS.zoom);
//             this.ls.set(LSSettingItems.city, city);
//         } else {
//             this.map.setBounds(this.getBounds());
//         }
//     }
//
//     initCanvas() {
//         this.scene = new THREE.Scene();
//         this.camera = new THREE.OrthographicCamera(this.width / -2, this.width / 2, this.height / 2, this.height / -2, 1, 1000);
//         this.renderer = new THREE.WebGLRenderer({antialias: true, alpha: true});
//         this.renderer.setPixelRatio(window.devicePixelRatio);
//         this.renderer.setSize(this.width, this.height);
//         this.renderer.sortObjects = false;
//         const pane = new ymaps.pane.StaticPane(this.map, {zIndex: 100});
//         pane.getElement().appendChild(this.renderer.domElement);
//         this.map.panes.append('canvas', pane);
//         this.camera.position.z = 200;
//         this.props.mapIsReady();
//     }
//
//     initListener() {
//         this.changeZoom = debounce(this.changeZoom, 500);
//         this.preCenter = [this.globalPixelCenter[0] - this.width / 2, this.globalPixelCenter[1] - this.height / 2];
//         this.preCenter = this.globalPixelCenter;
//         this.map.events.add('actiontickcomplete', this.handleTick.bind(this));
//         this.map.events.add('sizechange', this.handleResize.bind(this));
//         this.raycaster = new THREE.Raycaster();
//         this.raycaster.params.Points.threshold = 10;
//         this.mapContainer.addEventListener('mousemove', this.handleMouseMove.bind(this));
//         this.mapContainer.addEventListener('mousedown', this.handleMouseDown.bind(this));
//         this.mapContainer.addEventListener('mouseup', this.handleMouseUp.bind(this));
//         this.mapContainer.addEventListener('mouseleave', this.handleMouseLeave.bind(this));
//     }
//
//     initBlock(block: string, types: string[]) {
//         types.forEach(type => {
//             const element = document.createElement('div');
//             this[block][type] = element;
//             this[block].element.append(element);
//         });
//     };
//
//     initCarTooltip() {
//         this.initBlock('carTooltip', ['mainInfo']);
//     }
//
//     initFuelStationTooltip() {
//         this.initBlock('fuelTooltip', ['name', 'address', 'columns']);
//     }
//
//     handleMouseDown(e) {
//         this.mouseDown.isDown = true;
//         this.mouseDown.x = e.pageX;
//         this.mouseDown.y = e.pageY;
//         this.removeActivePoint();
//         this.hideCarTooltip();
//         this.hidePolyTooltip();
//     }
//
//     handleMouseUp(e) {
//         this.mouseDown.isDown = false;
//         if (this.isZoomCluster && this.mouseDown.x === e.pageX && this.mouseDown.y === e.pageY) {
//             this.map.setCenter(this.projection.fromGlobalPixels(
//                 this.map.converter.pageToGlobal([e.pageX, e.pageY]), this.zoom)
//             );
//             this.map.setZoom((this.zoom + 2 > 19) ? 19 : this.zoom + 2);
//         }
//         if (this.currentCar.id) {
//             location.href = `#/cars/${this.currentCar.id}/info`;
//         }
//     }
//
//     handleMouseMove(e) {
//         if (this.mouseDown.isDown) {
//             return;
//         }
//         this.hidePolyTooltip();
//         this.hideFuelTooltip();
//         this.isZoomCluster = false;
//         this.currentCar = false;
//         this.cursor.setKey('grab');
//
//         let mouse = new THREE.Vector2();
//         mouse.x = (e.offsetX / this.width) * 2 - 1;
//         mouse.y = -(e.offsetY / this.height) * 2 + 1;
//
//         this.raycaster.setFromCamera(mouse, this.camera);
//
//         const intersects = this.raycaster.intersectObjects(this.scene.children);
//         let intersectFuelStation;
//         if (this.props.fuelStations.length) {
//             const intersectsFuelStations = this.raycaster.intersectObject(this.fuelStationsPoints);
//             if (intersectsFuelStations[0]) {
//                 this.cursor.setKey('pointer');
//                 intersectFuelStation = intersectsFuelStations[0];
//                 this.showFuelTooltip(e.offsetX, e.offsetY, this.fuelStations[intersectFuelStation.index]);
//             }
//         }
//
//         if (this.props.isShowCars && !intersectFuelStation) {
//             const intersectsCars = this.raycaster.intersectObject(this.carPoints);
//             if (intersectsCars[0]) {
//                 this.cursor.setKey('pointer');
//                 const intersect = intersectsCars[0];
//                 this.activePoint(this.cars[intersect.index]);
//                 this.currentCar = this.cars[intersect.index];
//                 this.showCarTooltip(e.offsetX, e.offsetY, this.cars[intersect.index]);
//             } else {
//                 this.removeActivePoint();
//             }
//         }
//
//         if (intersects.length) {
//             if (intersects[0].object.name) {
//                 this.cursor.setKey('pointer');
//                 const object = JSON.parse(intersects[0].object.name);
//                 switch (object.type) {
//                     case 'poly':
//                         this.showPolyTooltip(e.offsetX, e.offsetY, this.poly[object.id]);
//                         this.hideCarTooltip();
//                         break;
//                     case 'cluster' :
//                         this.isZoomCluster = true;
//                         this.hideCarTooltip();
//                         break;
//                     case 'car' :
//                         const car = this.clusters[object.id].cars[0];
//                         this.currentCar = car;
//                         this.showCarTooltip(e.offsetX, e.offsetY, car);
//                         break;
//                 }
//             }
//         } else {
//             this.hideCarTooltip();
//         }
//     }
//
//     handleMouseLeave() {
//         this.removeActivePoint();
//         this.hideCarTooltip();
//         this.hidePolyTooltip();
//         this.hideFuelTooltip();
//     }
//
//     handleResize(e) {
//         [this.width, this.height] = e.get('newSize');
//         this.renderer.setSize(this.width, this.height);
//         this.camera.left = this.width / -2;
//         this.camera.right = this.width / 2;
//         this.camera.top = this.height / 2;
//         this.camera.bottom = this.height / -2;
//         this.camera.updateProjectionMatrix();
//
//         if (this.props.isShowCars) {
//             this.drawCars();
//         } else {
//             this.clustering(this.zoom);
//         }
//     }
//
//     showCarTooltip(x, y, car) {
//         this.carTooltip.element.style.display = 'block';
//         this.carTooltip.element.style.top = y - 250 + 'px';
//
//         if (this.carTooltip.element && (x + this.carTooltip.element.offsetWidth > this.width)) {
//             this.carTooltip.element.style.left = `${x - this.carTooltip.element.offsetWidth}px`;
//
//         } else {
//             this.carTooltip.element.style.left = `${x}px`;
//         }
//
//         if (this.carTooltip.element && (y - this.carTooltip.element.offsetHeight < 0)) {
//             this.carTooltip.element.style.top = `${y}px`;
//         } else {
//             this.carTooltip.element.style.top = `${y - 250}px`;
//         }
//
//         render(<CarTooltip car={car} modelsData={this.modelsData}/>, this.carTooltip.element);
//     }
//
//     showFuelTooltip(x, y, station) {
//         this.fuelTooltip.element.style.display = 'block';
//         this.fuelTooltip.element.style.top = y - 100 + 'px';
//         this.fuelTooltip.element.style.left = x + 'px';
//         this.fuelTooltip.name.innerText = `Название: ${station.name}`;
//         this.fuelTooltip.address.innerText = `Адрес: ${station.address}`;
//         let kindOfFuel: string[] = [];
//         station.columns.forEach(column => column.ft.forEach(kind => kindOfFuel.push(kind)));
//         this.fuelTooltip.columns.innerText = `Колонок: ${station.columns.length}  ${[...new Set(kindOfFuel)].join(', ')}`;
//     }
//
//     showPolyTooltip(x, y, poly) {
//         this.polyTooltip.style.display = 'block';
//         this.polyTooltip.style.top = y - 40 + 'px';
//         this.polyTooltip.style.left = x + 'px';
//         this.polyTooltip.innerText = [poly.area_title || poly.area_id, poly.area_tags || EMPTY_DATA].join(' — ');
//     }
//
//     hideCarTooltip() {
//         this.carTooltip.element.style.display = 'none';
//     }
//
//     hidePolyTooltip() {
//         this.polyTooltip.style.display = 'none';
//     }
//
//     hideFuelTooltip() {
//         this.fuelTooltip.element.style.display = 'none';
//     }
//
//     activePoint(car) {
//         let geometry = new THREE.Geometry();
//         let x = car.mapPosition[0] - this.mapGlobalPixelCenter[0];
//         let y = car.mapPosition[1] - this.mapGlobalPixelCenter[1];
//         geometry.vertices.push(
//             new THREE.Vector3(x, -y, 2)
//         );
//         let circle_sprite = new THREE.TextureLoader()
//             .load('https://carsharing.s3.yandex.net/drive/static/pins/white-2x.png', () => {
//                 let material = new THREE.PointsMaterial({
//                     size: 35,
//                     sizeAttenuation: false,
//                     map: circle_sprite,
//                     transparent: true
//                 });
//                 let point = new THREE.Points(geometry, material);
//                 this.removeActivePoint();
//                 this.hoverContainer.add(point);
//                 this.renderer.render(this.scene, this.camera);
//             });
//     }
//
//     removeActivePoint() {
//         this.hoverContainer && this.hoverContainer.remove(...this.hoverContainer.children);
//         this.renderer.render(this.scene, this.camera);
//     }
//
//     handleTick(e) {
//         let {zoom, globalPixelCenter} = e.get('tick');
//         this.globalPixelCenter = globalPixelCenter;
//         if (this.zoom !== zoom) {
//             // (this.zoom < zoom) ? this.camera.zoom *= 2 : this.camera.zoom /= 2;
//             // this.camera.updateProjectionMatrix();
//             this.zoom = zoom;
//             this.mapGlobalPixelCenter = globalPixelCenter;
//             this.changeZoom(zoom);
//             this.preCenter = this.globalPixelCenter;
//         } else {
//             if (!this.props.isShowCars) {
//                 this.updateSceneClusters();
//             }
//         }
//         let x = this.mapGlobalPixelCenter[0] - globalPixelCenter[0];
//         let y = this.mapGlobalPixelCenter[1] - globalPixelCenter[1];
//         //this.moveCamera(x / this.camera.zoom, y / this.camera.zoom);
//         this.moveCamera(x, y);
//     }
//
//     changeZoom(zoom: number) {
//         this.clearThree(this.scene && this.scene);
//         if (this.props.showPoly) {
//             this.getGlobalPositionForPoly(zoom);
//         }
//         if (this.props.isShowCars) {
//             this.drawCars();
//         } else {
//             this.clustering(zoom);
//         }
//         if (this.props.fuelStations.length) {
//             this.drawFuelStations();
//         }
//     }
//
//     moveCamera(x, y) {
//         this.camera.position.x = -x;
//         this.camera.position.y = y;
//         this.renderer.render(this.scene, this.camera);
//     };
//
//     getGlobalPositionForPoly(zoom: number) {
//         this.poly.forEach((pol: any) => {
//             pol.mapPosition = [];
//             pol.area_coords.forEach((coords: any) => {
//                 pol.mapPosition.push(this.projection.toGlobalPixels(coords, zoom));
//             });
//         });
//         this.drawPoly();
//     }
//
//     clustering(zoom: number) {
//         this.clusters = {};
//         this.cars.forEach(car => {
//             let x = MAGIC_ZOOM[zoom];
//             let clusterLat = Math.round(car.location.lat * x) / x;
//             let clusterLon = Math.round(car.location.lon * x) / x;
//             let idCluster = clusterLat + ':' + clusterLon;
//             if (this.clusters.hasOwnProperty(idCluster)) {
//                 this.clusters[idCluster].cars.push(car);
//                 this.clusters[idCluster].sumLat += car.location.lat;
//                 this.clusters[idCluster].sumLon += car.location.lon;
//                 if (this.clusters[idCluster].segments.hasOwnProperty(car[this.colorSource])) {
//                     this.clusters[idCluster].segments[car[this.colorSource]]++;
//                 } else {
//                     this.clusters[idCluster].segments[car[this.colorSource]] = 1;
//                 }
//             } else {
//                 this.clusters[idCluster] = {
//                     cars: [],
//                     segments: {},
//                     sumLat: car.location.lat,
//                     sumLon: car.location.lon
//                 };
//                 this.clusters[idCluster].cars.push(car);
//                 this.clusters[idCluster].segments[car[this.colorSource]] = 1;
//             }
//         });
//
//         for (let key in this.clusters) {
//             let clusterLat = this.clusters[key].sumLat / this.clusters[key].cars.length;
//             let clusterLon = this.clusters[key].sumLon / this.clusters[key].cars.length;
//             let mapPosition = this.projection.toGlobalPixels([clusterLon, clusterLat], this.zoom);
//             this.clusters[key].lat = clusterLat;
//             this.clusters[key].lon = clusterLon;
//             this.clusters[key].mapPosition = mapPosition;
//         }
//         this.clusterKeys = Object.keys(this.clusters);
//         this.addSceneClusters();
//     }
//
//     drawPoly() {
//         this.poly.forEach((pol, index) => {
//             let polyPoints: any[] = [];
//             pol.mapPosition.forEach(pos => {
//                 const x = pos[0] - this.mapGlobalPixelCenter[0];
//                 const y = pos[1] - this.mapGlobalPixelCenter[1];
//                 polyPoints.push(new THREE.Vector2(x, -y));
//             });
//             const polyShape = new THREE.Shape(polyPoints);
//             const geometry = new THREE.ShapeBufferGeometry(polyShape);
//             const material = new THREE.MeshBasicMaterial({
//                 color: pol.color,
//                 opacity: 0.1,
//                 transparent: true
//             });
//             const poly = new THREE.Mesh(geometry, material);
//             poly.name = `{"type": "poly", "id": ${index}}`;
//             poly.position.z = 0.000000000001 * index;
//             this.scene.add(poly);
//         });
//
//         this.renderer.render(this.scene, this.camera);
//     }
//
//     addSceneCluster(key) {
//         const {mapPosition, cars, segments} = this.clusters[key];
//         const numberCars = cars.length;
//         if (numberCars === 1) {
//             this.scene.add(this.drawCar(mapPosition[0] - this.mapGlobalPixelCenter[0], mapPosition[1] - this.mapGlobalPixelCenter[1], key));
//         } else {
//             let segmentOption: any = [];
//             Object.keys(segments).forEach(key => {
//                 segmentOption.push({
//                     percent: segments[key] / numberCars * 100,
//                     color: CAR_COLORS[key] || 0xfed700
//                 });
//             });
//             this.clusters[key].isDraw = true;
//             this.scene.add(this.drawChart(mapPosition[0] - this.mapGlobalPixelCenter[0], mapPosition[1] - this.mapGlobalPixelCenter[1], numberCars, segmentOption, key));
//         }
//     }
//
//     addSceneClusters() {
//         this.clusterKeys.forEach(key => {
//             let {mapPosition} = this.clusters[key];
//             let center = [this.globalPixelCenter[0], this.globalPixelCenter[1]];
//             if (
//                 mapPosition[0] > center[0] - this.width / 2 &&
//                 mapPosition[0] < center[0] + this.width / 2 &&
//                 mapPosition[1] > center[1] - this.height / 2 &&
//                 mapPosition[1] < center[1] + this.height / 2
//             ) {
//                 this.addSceneCluster(key);
//             }
//         });
//         this.hoverContainer = new THREE.Object3D();
//         this.scene.add(this.hoverContainer);
//         this.renderer.render(this.scene, this.camera);
//     }
//
//     updateSceneClusters() {
//         let center = this.globalPixelCenter;
//         if (center[1] - this.preCenter[1] > 0) {
//             this.clusterKeys.forEach(key => {
//                 if (!this.clusters[key].isDraw &&
//                     this.clusters[key].mapPosition[0] > center[0] - this.width / 2 &&
//                     this.clusters[key].mapPosition[0] < center[0] + this.width / 2 &&
//                     this.clusters[key].mapPosition[1] > this.preCenter[1] + this.height / 2 &&
//                     this.clusters[key].mapPosition[1] < center[1] + this.height / 2
//                 ) {
//                     this.addSceneCluster(key);
//                 }
//             });
//         } else if (center[1] - this.preCenter[1] < 0) {
//             this.clusterKeys.forEach(key => {
//                 if (!this.clusters[key].isDraw &&
//                     this.clusters[key].mapPosition[0] > center[0] - this.width / 2 &&
//                     this.clusters[key].mapPosition[0] < center[0] + this.width / 2 &&
//                     this.clusters[key].mapPosition[1] > center[1] - this.height / 2 &&
//                     this.clusters[key].mapPosition[1] < this.preCenter[1] - this.height / 2
//                 ) {
//                     this.addSceneCluster(key);
//                 }
//             });
//         }
//
//         if (center[0] - this.preCenter[0] > 0) {
//             this.clusterKeys.forEach(key => {
//                 if (!this.clusters[key].isDraw &&
//                     this.clusters[key].mapPosition[0] > this.preCenter[0] + this.width / 2 &&
//                     this.clusters[key].mapPosition[0] < center[0] + this.width / 2 &&
//                     this.clusters[key].mapPosition[1] > center[1] - this.height / 2 &&
//                     this.clusters[key].mapPosition[1] < center[1] + this.height / 2
//                 ) {
//                     this.addSceneCluster(key);
//                 }
//             });
//         } else if (center[0] - this.preCenter[0] < 0) {
//             this.clusterKeys.forEach(key => {
//                 if (!this.clusters[key].isDraw &&
//                     this.clusters[key].mapPosition[0] > center[0] - this.width / 2 &&
//                     this.clusters[key].mapPosition[0] < this.preCenter[0] - this.width / 2 &&
//                     this.clusters[key].mapPosition[1] > center[1] - this.height / 2 &&
//                     this.clusters[key].mapPosition[1] < center[1] + this.height / 2
//                 ) {
//                     this.addSceneCluster(key);
//                 }
//             });
//         }
//         this.preCenter = center;
//         this.renderer.render(this.scene, this.camera);
//     }
//
//     clearThree(obj) {
//         while (obj.children.length > 0) {
//             this.clearThree(obj.children[0]);
//             obj.remove(obj.children[0]);
//         }
//         if (obj.geometry) {
//             obj.geometry.dispose();
//         }
//         if (obj.material) {
//             obj.material.dispose();
//         }
//         if (obj.texture) {
//             obj.texture.dispose();
//         }
//     }
//
//     addGlobalCordToCars(zoom: number) {
//         this.cars.forEach(car => {
//             car.mapPosition = this.projection.toGlobalPixels([car.location.lon, car.location.lat], zoom);
//         });
//     }
//
//     addGlobalCordToFuelStations(zoom: number) {
//         this.fuelStations.forEach(station => {
//             const location = station.location.split(' ');
//             station.mapPosition = this.projection.toGlobalPixels(location, zoom);
//         });
//     }
//
//     drawCars() {
//         this.addGlobalCordToCars(this.zoom);
//         let carsGeometry = new THREE.Geometry();
//         let colors: any[] = [];
//         this.cars.forEach(car => {
//             let x = car.mapPosition[0] - this.mapGlobalPixelCenter[0];
//             let y = car.mapPosition[1] - this.mapGlobalPixelCenter[1];
//             let vertex = new THREE.Vector3(x, -y, 1);
//             carsGeometry.vertices.push(vertex);
//             colors.push(new THREE.Color(CAR_COLORS[car[this.colorSource]]));
//         });
//         carsGeometry.colors = colors;
//         const opacity = Math.max(0.1, ((100 - 20) / (19 - 10) * (this.zoom - 10) + 20) / 100);
//         let circle_sprite = new THREE.TextureLoader().load(
//             'https://carsharing.s3.yandex.net/drive/static/pins/white-2x.png'
//             , () => {
//                 let pointsMaterial = new THREE.PointsMaterial({
//                     size: 20,
//                     // sizeAttenuation: false,
//                     // fog: false,
//                     depthTest: false,
//                     vertexColors: THREE.VertexColors,
//                     opacity,
//                     map: circle_sprite,
//                     transparent: true
//                 });
//                 this.carPoints = new THREE.Points(carsGeometry, pointsMaterial);
//                 this.scene.add(this.carPoints);
//                 this.renderer.render(this.scene, this.camera);
//                 this.hoverContainer = new THREE.Object3D();
//                 this.scene.add(this.hoverContainer);
//             });
//     }
//
//     drawFuelStations() {
//         this.addGlobalCordToFuelStations(this.zoom);
//         let fuelStationsGeometry = new THREE.Geometry();
//         this.fuelStations.forEach(car => {
//             let x = car.mapPosition[0] - this.mapGlobalPixelCenter[0];
//             let y = car.mapPosition[1] - this.mapGlobalPixelCenter[1];
//             let vertex = new THREE.Vector3(x, -y, 1);
//             fuelStationsGeometry.vertices.push(vertex);
//         });
//         let circle_sprite = new THREE.TextureLoader().load(
//             'http://artyombobr.ml/yandex/images/fuelStation.svg'
//             , () => {
//                 let pointsMaterial = new THREE.PointsMaterial({
//                     size: 25,
//                     depthTest: false,
//                     map: circle_sprite,
//                     transparent: true
//                 });
//                 this.fuelStationsPoints = new THREE.Points(fuelStationsGeometry, pointsMaterial);
//                 this.scene.add(this.fuelStationsPoints);
//                 this.renderer.render(this.scene, this.camera);
//             });
//     }
//
//     applyVertexColors(geometry, color) {
//         const position = geometry.attributes.position;
//         let colors: any[] = [];
//         for (let i = 0; i < position.count; i++) {
//             colors.push(color.r, color.g, color.b);
//         }
//         geometry.addAttribute('color', new THREE.Float32BufferAttribute(colors, 3));
//     }
//
//     drawCar(x, y, name) {
//         const color = new THREE.Color();
//         let geometriesDrawn: any[] = [];
//         const backCircleGeometry = new THREE.CircleBufferGeometry(15, 32);
//         this.applyVertexColors(backCircleGeometry, color.setHex(0xffffff));
//         geometriesDrawn.push(backCircleGeometry);
//         const frontCircleGeometry = new THREE.CircleBufferGeometry(10, 32);
//         this.applyVertexColors(frontCircleGeometry, color.setHex(CAR_COLORS[this.clusters[name].cars[0][this.colorSource]]));
//         geometriesDrawn.push(frontCircleGeometry);
//         const mergedObject = BufferGeometryUtils.mergeBufferGeometries(geometriesDrawn);
//         const defaultMaterial = new THREE.MeshBasicMaterial({
//             vertexColors: THREE.VertexColors
//         });
//         const car = new THREE.Mesh(mergedObject, defaultMaterial);
//         car.position.x = x;
//         car.position.y = -y;
//         car.position.z = 0.0001;
//         car.name = `{"type": "car", "id": "${name}"}`;
//         return car;
//     }
//
//     drawChart(x, y, numberCars, segmentOption, name) {
//         const color = new THREE.Color();
//         let geometriesDrawn: any[] = [];
//         const backCircle = new THREE.CircleBufferGeometry(Math.min(30 * (1 + numberCars / 2500), 49), 32);
//         this.applyVertexColors(backCircle, color.setHex(0xffffff));
//         geometriesDrawn.push(backCircle);
//         let start = 0;
//         let end;
//         const space = (segmentOption.length === 1) ? 0 : 0.05;
//         segmentOption.forEach(segmentV => {
//             end = Math.PI * 2 / 100 * segmentV.percent;
//             const segment = new THREE.CircleBufferGeometry(Math.min(26 * (1 + numberCars / 2500), 44), 32, start, end - space);
//             this.applyVertexColors(segment, color.setHex(segmentV.color));
//             start = start + end;
//             geometriesDrawn.push(segment);
//         });
//         const frontCircle = backCircle.clone();
//         frontCircle.scale(0.6, 0.6, 1);
//         geometriesDrawn.push(frontCircle);
//         const loader = new THREE.FontLoader();
//         const font = loader.parse(jsonFont);
//         const shapes = font.generateShapes(numberCars.toString(), 14, 2);
//
//         const textGeometry = new THREE.ShapeBufferGeometry(shapes);
//         textGeometry.computeBoundingBox();
//         const textWidth = textGeometry.boundingBox.max.x;
//         const textHeight = textGeometry.boundingBox.max.y;
//         textGeometry.translate(-0.5 * textWidth, -0.5 * textHeight, 0);
//
//         const defaultMaterial = new THREE.MeshBasicMaterial({
//             vertexColors: THREE.VertexColors
//         });
//         const mergedObject = BufferGeometryUtils.mergeBufferGeometries(geometriesDrawn);
//         let chart = new THREE.Mesh(mergedObject, defaultMaterial);
//
//         const text = new THREE.Mesh(textGeometry, new THREE.MeshBasicMaterial({color: 0x000000}));
//         text.position.x = x;
//         text.position.y = -y;
//         text.position.z = 0.0001;
//         chart.children.push(text);
//         chart.position.x = x;
//         chart.position.y = -y;
//         chart.position.z = 0.0001;
//         chart.name = `{"type": "cluster", "id": "${name}"}`;
//         return chart;
//     };
//
//     onCarsFiltersClose() {
//         this.setState({carsFiltersIsOpen: false, evacuationIsOpen: false});
//     }
//
//     render() {
//         return <>
//             <div id="map" className={style.map__ymap} ref={element => this.mapContainer = element}/>
//             <div className={style.map__canvas} ref={element => this.threeRootElement = element}/>
//             <div className={style.tooltip} ref={element => this.carTooltip.element = element}/>
//             <div className={style.tooltip} ref={element => this.polyTooltip = element}/>
//             <div className={style.tooltip} ref={element => this.fuelTooltip.element = element}/>
//             {
//                 this.state.carsFiltersIsOpen
//                     ? <CarsFilter onClose={this.onCarsFiltersClose.bind(this)}/>
//                     : null
//             }
//         </>;
//     }
// }
//
// export default MapCanvas;
// */
