/*eslint-disable*/
import * as React from 'react';
import style from './index.css';
import { connect } from 'react-redux';
import { IStore } from '../../App/store';
import { IBlockRules } from '../../../utils/IBlockRules';

export interface IShortOffer {
    name: string;
    cars_count: number;
    title?: string;
}

export interface IOffers {
    [key: string]: IShortOffer
}

export interface IProps extends IBlockRules {
    offers: IOffers;
    currentFilters: {},
    selectItem: () => void;
    packActions?: string[];
}

export const OTHERS = 'Другие';
const MINUTES_GROUP_NAME = 'Минуты';

class OffersFilter extends React.Component<IProps, any> {

    groupOffers(): { [key: string]: any } {
        let {offers = {}} = this.props;
        return Object.entries(offers).reduce((res: any, curr: any) => {
            let value = curr[1];
            let group_name = value.group_name ? value.group_name.toString().trim() : OTHERS;
            let offerName = value.name;

            if (offerName === MINUTES_GROUP_NAME) {
                res.total.minutes += value.cars_count;
            } else {
                if (res.groups[group_name]) {
                    if (res.groups[group_name].offers[offerName]) {
                        res.groups[group_name].offers[offerName].cars_count += value.cars_count;
                    } else {
                        res.groups[group_name].offers[offerName] = Object.assign({}, value);
                    }
                    res.groups[group_name].total += value.cars_count;
                } else {
                    res.groups[group_name] = {offers: {[offerName]: value}, total: value.cars_count || 0};
                }
            }

            res.total.all += value.cars_count;

            return res;
        }, {groups: {}, total: {all: 0, minutes: 0}});
    }

    render() {
        let itemsByGroup = this.groupOffers();
        return this.props.BlockRules?.FilterTariff && itemsByGroup.total.all &&
            <div className={style['legend-statuses']}>
                <table>
                    <tbody>
                    {
                        [['Все тарифы', '', 'all'], [MINUTES_GROUP_NAME, MINUTES_GROUP_NAME, 'minutes']]
                            .map(item => {
                                return <tr key={item[2]}
                                           onClick={this.props.selectItem.bind(null, item[1], 'offer_group_name')}
                                >
                                    <td className={style['group-name']}>{item[0]}:</td>
                                    <td className={style.count}>{itemsByGroup.total[item[2]]}</td>
                                </tr>;
                            })
                    }
                    {Object.entries(itemsByGroup.groups)
                        .sort((a: any, b: any) => {
                            if (a[0] === OTHERS) {
                                return 1;
                            }
                            if (b[0] === OTHERS) {
                                return -1;
                            }

                            return a[0].localeCompare(b[0]);
                        })
                        .map(entry => {
                            let [groupName] = entry;
                            let groupValue: any = entry[1];
                            // let isSelectedGroup = Object.keys(groupValue.offers).sort().join('')
                            //     === this.props.selectedOffer.sort().join('');
                            let groupRow = <tr key={groupName}
                                               className={this.props.currentFilters['offer_group_name'] === groupName ? style.selected : ''}
                                               onClick={this.props.selectItem.bind(null, groupName, 'offer_group_name')}
                                               title={groupName}>
                                <td className={style['group-name']} title={groupName}>{groupName}:</td>
                                <td className={style.count}>{groupValue.total}</td>
                            </tr>;
                            let offers: { [key: string]: IShortOffer } = groupValue.offers;
                            let offersRows = Object.values(offers)
                                .sort((a, b) => b.cars_count - a.cars_count)
                                .map((item: IShortOffer, index: number) => {
                                    return <tr
                                        key={index}
                                        // className={this.props.selectedOffer.includes(item.name)
                                        // && this.props.selectedOfferGroup === groupName ? style.selected : ''}
                                        className={this.props.currentFilters['offer_name'] === item.name
                                            ? style.selected : ''}
                                        title={item.title}
                                        onClick={this.props.selectItem.bind(null, item.name, 'offer_name')}
                                    >
                                        <td className={style['offer-name']} title={item.name}>{item.name}</td>
                                        <td className={style.count}>{item.cars_count}</td>
                                    </tr>;
                                });

                            return [groupRow, ...offersRows];
                        })}
                    </tbody>
                </table>
            </div> || null;
    }
}

export const mapStateToProps = (store: IStore): IBlockRules => {
    return {
        BlockRules: store.AdminUser && store.AdminUser.blockRules || {}
    };
};

export function mapDispatchToProps(dispatch: any) {
    return {};
}

export default connect(mapStateToProps, mapDispatchToProps)(OffersFilter);
