// import React from 'react';
// import MapCanvas from './MapCanvas';
// import Legend from './Legend';
// import {
//     CAR_COLORS,
//     CAR_UPDATE_INTERVAL,
//     DEFAULT_COORDINATES,
//     idleRanges,
//     ONE_SECOND,
//     surgeRanges
// } from '../../constants/';
// import { Request2 } from '../../utils/request';
// import { ICar, IFuelStation, IPoly } from '../../../types';
// import { MAP_REQUESTS, REQUESTS } from './request';
// import style from './index.css';
// import { connect } from 'react-redux';
// import { getRawSetting } from '../../utils/getRawSetting';
// import { IStore } from '../App/store';
//
// interface IMainMapState {
//     colorSource: string,
//     isShowCars: boolean,
//     showPoly: boolean,
//     fuelStations: IFuelStation[],
//     showCars: ICar[],
//     statuses: {},
//     models: {},
//     idles: {},
//     kffs: {},
//     poly: IPoly[],
//     mapIsReady: boolean,
//     isLoading: boolean,
//     error: Error | null
// }
//
// const idleNameLength = 72;
//
// class MainMap extends React.Component<any, IMainMapState> {
//
//     request = new Request2({requestConfigs: MAP_REQUESTS});
//
//     state = {
//         colorSource: 'status',
//         isShowCars: false,
//         showPoly: false,
//         fuelStations: [],
//         showCars: [],
//         statuses: {},
//         models: {},
//         idles: {},
//         kffs: {},
//         poly: [],
//         mapIsReady: false,
//         isLoading: true,
//         error: null
//     };
//
//     carFilter = {
//         currentFilters: {},
//         lastClickFilter: null
//     };
//
//     cars;
//     modelsData = {};
//     offers = {};
//     poly;
//     time;
//     idleName = Array(idleNameLength);
//
//     componentDidMount(): void {
//         this.time = Date.now();
//         idleRanges.forEach(range => {
//             for (let i = range[0]; i <= range[1]; i++) {
//                 this.idleName[i] = range[1];
//             }
//         });
//         this.getCars();
//     }
//
//     componentDidCatch(error: any) {
//         this.setState({error});
//     }
//
//     updateCar() {
//         setTimeout(() => {
//             this.getCars();
//         }, CAR_UPDATE_INTERVAL);
//     }
//
//     getPolyColor(area_tags) {
//         return area_tags.indexOf('allow_riding') > -1
//             ? 0x1000FF00
//             : area_tags.indexOf('allow_drop') > -1
//                 ? 0x3000FF00
//                 : area_tags.indexOf('impoundment_lot') > -1
//                     ? 0x20FAA000
//                     : area_tags.indexOf('deny_drop_car') == 0
//                         ? 0x60FF0000
//                         : area_tags.indexOf('cargo_deny_drop_car') > -1
//                             ? ('all' == 'all' ? 0x50FF8000 : 0x60FF0000)
//                             //? 0xFF800050
//                             : area_tags.indexOf('shuttle_deny_drop_car') == 0
//                                 ? 0x60ffafff
//                                 : 0x100000ff;
//     }
//
//     shouldComponentUpdate(nextProps, nextState: Readonly<IMainMapState>): boolean {
//         return (nextState.mapIsReady && !!nextState.showCars.length);
//     }
//
//     getCars() {
//         this.request.exec(REQUESTS.GET_CARS)
//             .then(data => {
//                 this.updateCar();
//                 this.cars = data.cars;
//                 this.cars.forEach((car, index) => {
//                     this.cars[index].color = CAR_COLORS[car.status];
//                     if (!car.location) {
//                         car.location = {};
//                         car.location.lat = DEFAULT_COORDINATES.LAT;
//                         car.location.lon = DEFAULT_COORDINATES.LON;
//                     }
//                     if (car.offer_group_name === 'Часы ') {
//                         car.offer_group_name = 'Часы';
//                     }
//                     this.cars[index].__idle = this
//                         .getIdle(this.cars[index].surge &&
//                             this.cars[index].surge.idle_start &&
//                             this.cars[index].surge.idle_start ||
//                             this.time
//                         );
//                     this.cars[index].__kff = this
//                         .getKff(
//                             this.cars[index].surge && this.cars[index].surge.kff && this.cars[index].surge.kff ||
//                             0
//                         );
//                     this.cars[index].__city = this
//                         .getCity(
//                             this.cars[index].location.areas &&
//                             this.cars[index].location.areas.map(area => area.id) ||
//                             []
//                         );
//                 });
//                 this.modelsData = data.models;
//                 this.offers = data.offers;
//                 this.carsFiltering();
//             });
//     }
//
//     getIdle(idle_start) {
//         const idle = Math.round((this.time / ONE_SECOND - idle_start) / 3600);
//         return (idle <= 0 || idle > idleNameLength) ? 'h72_more' : 'h' + this.idleName[idle];
//     }
//
//     getKff(surge) {
//         for (let i = 1; i < surgeRanges.length; i++) {
//             if (surge <= surgeRanges[i]) {
//                 return 'less_' + surgeRanges[i];
//             }
//         }
//         return 'more_2';
//     }
//
//     getCity(areas: string[]): string {
//         const n = areas.length;
//         for (let i = 0; i < n; i++) {
//             const area = areas[i];
//             switch (area) {
//                 case '47km':
//                     return 'KM_47';
//                 case 'global_MSK' :
//                     return 'MOSCOW';
//                 case 'global_SPB' :
//                     return 'PITER';
//                 case 'global_KAZAN' :
//                     return 'KAZAN';
//             }
//         }
//         return 'SKLAD';
//     }
//
//     getFilters(showCars, carsData) {
//         const {lastClickFilter} = this.carFilter;
//         let statuses = {};
//         let models = {};
//         let idles = {};
//         let kffs = {};
//
//         showCars.forEach(car => {
//             const idle = car.__idle;
//             const kff = car.__kff;
//
//             if (kffs.hasOwnProperty(kff)) {
//                 kffs[kff]++;
//             } else {
//                 kffs[kff] = 1;
//             }
//
//             if (idles.hasOwnProperty(idle)) {
//                 idles[idle]++;
//             } else {
//                 idles[idle] = 1;
//             }
//
//             if (statuses.hasOwnProperty(car.status)) {
//                 statuses[car.status]++;
//             } else {
//                 statuses[car.status] = 1;
//             }
//
//             if (models.hasOwnProperty(car.model_id)) {
//                 models[car.model_id]++;
//             } else {
//                 models[car.model_id] = 1;
//             }
//         });
//
//         if (!lastClickFilter) {
//             this.setState({showCars, statuses, models, idles, kffs, ...carsData});
//         }
//         if (lastClickFilter === 'status') {
//             this.setState({showCars, models, idles, kffs, ...carsData});
//         }
//         if (lastClickFilter === 'model_id') {
//             this.setState({showCars, statuses, idles, kffs, ...carsData});
//         }
//         if (lastClickFilter === '__idle') {
//             this.setState({showCars, statuses, models, kffs, ...carsData});
//         }
//         if (lastClickFilter === '__kff') {
//             this.setState({showCars, statuses, models, idles, ...carsData});
//         }
//         if (lastClickFilter === '__city') {
//             this.setState({showCars, statuses, models, idles, kffs, ...carsData});
//         }
//         if (lastClickFilter === 'offer_group_name') {
//             this.setState({
//                 showCars,
//                 statuses,
//                 models,
//                 idles,
//                 kffs, ...carsData
//             });
//         }
//         if (lastClickFilter === 'offer_name') {
//             this.setState({showCars, statuses, models, idles, kffs, ...carsData});
//         }
//     }
//
//     handleChangeColorSource(source) {
//         this.setState({
//                 colorSource: (source === this.state.colorSource) ? 'status' : source
//             }
//         );
//     }
//
//     mapIsReady() {
//         this.setState({mapIsReady: true});
//     }
//
//     showCars() {
//         this.setState({isShowCars: true});
//     }
//
//     showClusters() {
//         this.setState({isShowCars: false});
//     }
//
//     getFueling(isShow) {
//         if (isShow) {
//             this.request.exec(REQUESTS.GET_FUELING).then(data => {
//                 this.setState({fuelStations: data.map.stations});
//             });
//         } else {
//             this.setState({fuelStations: []});
//         }
//     }
//
//     polyFiltering(polyFilter) {
//         if (polyFilter) {
//             return new Promise(resolve => {
//                 this.request.exec(REQUESTS.GET_POLY).then(data => {
//                     this.poly = data.areas;
//                     const {tags = [], filter} = polyFilter;
//                     const compare = poly => {
//                         poly.color = this.getPolyColor(poly.area_tags);
//                         let flag = !tags.length;
//                         poly.area_tags?.split(',').forEach(tag => {
//                             let tag_trimmed = tag.trim();
//                             if (tags.includes(tag_trimmed)) {
//                                 flag = true;
//                             }
//                             filter && filter.forEach(str => {
//                                 if (tag_trimmed.includes(str)) {
//                                     flag = true;
//                                 }
//                             });
//                         });
//                         return flag;
//                     };
//                     this.setState({showPoly: true, poly: this.poly.filter(compare)}, () => {
//                         resolve();
//                     });
//                 });
//             });
//         } else {
//             return new Promise(resolve => {
//                 this.setState({showPoly: false}, () => {
//                     resolve();
//                 });
//             });
//         }
//     }
//
//     carsFiltering() {
//         let {currentFilters} = this.carFilter;
//         const currentFiltersArray = Object.entries(currentFilters);
//         const compare = car => {
//             let flag = true;
//             currentFiltersArray.forEach(filter => {
//                 if (car[filter[0]] !== filter[1]) {
//                     flag = false;
//                 }
//             });
//             return flag;
//         };
//         this.getFilters(this.cars.filter(compare), {isLoading: true});
//     }
//
//     handleCarsFilterClick(key, type) {
//         if (type === 'offer_group_name' || type === 'offer_name') {
//             this.carFilter.currentFilters = {};
//         }
//
//         this.carFilter.lastClickFilter = key === null ? null : type;
//         if (key) {
//             this.carFilter.currentFilters = {...this.carFilter.currentFilters, [type]: key};
//         } else {
//             delete this.carFilter.currentFilters[type];
//         }
//         this.carsFiltering();
//     };
//
//
//     render() {
//         return this.state.error
//             ? <>
//                 <h1>Карта - это самое дорогое, мы ее скоро починим.</h1>
//                 <h2>А пока попробуйте обновить страничку...</h2>
//             </>
//             : <div className={style.map}>
//                 <MapCanvas
//                     colorSource={this.state.colorSource}
//                     isShowCars={this.state.isShowCars}
//                     cars={this.state.showCars}
//                     filter={this.carFilter}
//                     handleCarsFilterClick={this.handleCarsFilterClick.bind(this)}
//                     modelsData={this.modelsData}
//                     showPoly={this.state.showPoly}
//                     poly={this.state.poly}
//                     polyFiltering={this.polyFiltering.bind(this)}
//                     getFueling={this.getFueling.bind(this)}
//                     fuelStations={this.state.fuelStations}
//                     mapIsReady={this.mapIsReady.bind(this)}
//                     polyFilters={this.props.polyFilters}
//                     BlockRules={this.props.BlockRules}
//                 />
//                 <Legend
//                     numberCars={this.state.showCars.length || 0}
//                     showCars={this.showCars.bind(this)}
//                     isShowCars={this.state.isShowCars}
//                     showClusters={this.showClusters.bind(this)}
//                     filter={this.carFilter}
//                     handleCarsFilterClick={this.handleCarsFilterClick.bind(this)}
//                     carsFiltering={this.carsFiltering.bind(this)}
//                     statuses={this.state.statuses}
//                     models={this.state.models}
//                     offers={this.offers}
//                     idles={this.state.idles}
//                     kffs={this.state.kffs}
//                     handleChangeColorSource={this.handleChangeColorSource.bind(this)}
//                     colorSource={this.state.colorSource}
//                 />
//             </div>;
//     }
// }
//
// const SETTING_KEY = 'interface_admin.polyFilters';
//
// const mapStateToProps = (store: IStore) => {
//     let polyFilters = getRawSetting(store, SETTING_KEY);
//
//     return {
//         polyFilters,
//         BlockRules: store?.AdminUser?.blockRules || {}
//     };
// };
//
//
// export default connect(mapStateToProps)(MainMap);
