import { IComponentRequest } from '../../utils/request';

export enum REQUESTS {
    GET_CARS = 'GET_CARS',
    GET_CAR_INFO = 'GET_CAR_INFO',
    GET_POLY = 'GET_POLY',
    GET_FUELING = 'GET_FUELING',
    GET_SESSIONS = 'GET_SESSIONS',
    GET_CAR_TAGS = 'GET_CAR_TAGS',
}

export const MAP_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_CARS]: {
        api: 'car/list',
        cgiObj: {
            //traits: 'ReportLocationDetails'
        },
    },
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_POLY]: {
        api: 'areas/info',
    },
    [REQUESTS.GET_FUELING]: {
        api: 'fueling/map',
    },
    [REQUESTS.GET_SESSIONS]: {
        api: 'sessions/history',
        cgiObj: {
            car_id: null,
            numdoc: null,
        },
    },
    [REQUESTS.GET_CAR_TAGS]: {
        api: 'car/tag/list',
        cgiObj: {
            car_id: null,
        },
    },
};
